/*
 * Decompiled with CFR 0.152.
 */
package codacy.foundation.files;

import codacy.foundation.files.CommitDirectory;
import codacy.foundation.files.FileSystemProviderBase$;
import codacy.foundation.files.FileSystemProviderImpl;
import codacy.foundation.files.IgnoreDirectoryFilter;
import codacy.foundation.files.SymlinkFilter;
import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FileUtils;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public abstract class FileSystemProviderImpl$class {
    public static CommitDirectory getCommitDirectory(FileSystemProviderImpl $this, String projectKey, String commitKey) {
        boolean createDirectory;
        File projectDir = FileSystemProviderImpl$class.getProjectDirectory($this, projectKey);
        File commitDir = new File(projectDir, commitKey);
        boolean bl = createDirectory = !FileSystemProviderImpl$class.hasCommitDirectory($this, projectKey, commitKey);
        if (createDirectory) {
            $this.removeCommitDirectory(projectKey, commitKey);
            FileSystemProviderImpl$class.createIfNotExists($this, commitDir);
        }
        return new CommitDirectory(commitDir, createDirectory);
    }

    public static void removeProjectDirectory(FileSystemProviderImpl $this, String projectKey) {
        File projectDir = FileSystemProviderImpl$class.getProjectDirectory($this, projectKey);
        FileSystemProviderBase$.MODULE$.removeDirectories((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{projectDir}))));
    }

    public static void removeCommitDirectory(FileSystemProviderImpl $this, String projectKey, String commitKey) {
        File projectDir = FileSystemProviderImpl$class.getProjectDirectory($this, projectKey);
        File commitDir = new File(projectDir, commitKey);
        FileSystemProviderBase$.MODULE$.removeDirectories((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{commitDir}))));
    }

    public static void removeAllCommitDirectoriesExcept(FileSystemProviderImpl $this, String projectKey, Seq commitKeyExceptions) {
        File projectDir = FileSystemProviderImpl$class.getProjectDirectory($this, projectKey);
        String[] commitKeysToDelete = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])projectDir.listFiles()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$4) {
                return x$4.getName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filterNot((Function1)new Serializable($this, commitKeyExceptions){
            public static final long serialVersionUID = 0L;
            private final Seq commitKeyExceptions$1;

            public final boolean apply(Object elem) {
                return this.commitKeyExceptions$1.contains(elem);
            }
            {
                this.commitKeyExceptions$1 = commitKeyExceptions$1;
            }
        });
        File[] filesToDelete = (File[])Predef$.MODULE$.refArrayOps((Object[])commitKeysToDelete).map((Function1)new Serializable($this, projectDir){
            public static final long serialVersionUID = 0L;
            private final File projectDir$1;

            public final File apply(String c) {
                return new File(this.projectDir$1, c);
            }
            {
                this.projectDir$1 = projectDir$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        FileSystemProviderBase$.MODULE$.removeDirectories((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])filesToDelete));
    }

    public static boolean createCommitDirectory(FileSystemProviderImpl $this, String projectKey, String headKey, String commitKey) {
        boolean bl;
        try {
            File projectDir = FileSystemProviderImpl$class.getProjectDirectory($this, projectKey);
            File headDir = new File(projectDir, headKey);
            File commitDir = new File(projectDir, commitKey);
            $this.getCommitDirectory(projectKey, commitKey);
            FileUtils.copyDirectory((File)headDir, (File)commitDir, (FileFilter)new SymlinkFilter());
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("Exception", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = bl2 = false;
        }
        return bl;
    }

    public static Option copyDirectory(FileSystemProviderImpl $this, File source, File target) {
        Some some;
        FileSystemProviderBase$.MODULE$.removeDirectories((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{target}))));
        try {
            FileUtils.copyDirectory((File)source, (File)target, (FileFilter)new SymlinkFilter());
            some = new Some((Object)target);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("Exception", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public static Seq listFiles(FileSystemProviderImpl $this, File dir) {
        return FileSystemProviderBase$.MODULE$.listFiles(dir, $this.ignoreDirectoryFilter(), $this.symlinkFilter());
    }

    private static boolean hasCommitDirectory(FileSystemProviderImpl $this, String projectKey, String commitKey) {
        File projectDirectory = FileSystemProviderImpl$class.getProjectDirectory($this, projectKey);
        File commitDir = new File(projectDirectory, commitKey);
        return commitDir.exists();
    }

    /*
     * WARNING - void declaration
     */
    private static File getProjectDirectory(FileSystemProviderImpl $this, String projectKey) {
        void var3_3;
        File rootDir = new File($this.repositoryLocation());
        FileSystemProviderImpl$class.createIfNotExists($this, rootDir);
        File projectDir = new File(rootDir, projectKey);
        FileSystemProviderImpl$class.createIfNotExists($this, projectDir);
        return var3_3;
    }

    private static void createIfNotExists(FileSystemProviderImpl $this, File file) {
        if (!file.exists()) {
            BoxedUnit boxedUnit;
            if (file.mkdirs()) {
                if (!file.setWritable(true, false)) {
                    BoxedUnit boxedUnit2;
                    if ($this.logger().underlying().isErrorEnabled()) {
                        $this.logger().underlying().error("Error setting file writable: {}", new Object[]{file.getName()});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                }
            } else if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error(new StringOps(Predef$.MODULE$.augmentString("Should be able to create directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getPath()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static void $init$(FileSystemProviderImpl $this) {
        $this.codacy$foundation$files$FileSystemProviderImpl$_setter_$ignoreDirectoryFilter_$eq(new IgnoreDirectoryFilter());
        $this.codacy$foundation$files$FileSystemProviderImpl$_setter_$symlinkFilter_$eq(new SymlinkFilter());
    }
}

