/*
 * Decompiled with CFR 0.152.
 */
package codacy.foundation.files;

import codacy.foundation.api.FileContents$;
import codacy.foundation.files.FileSystemProviderBase$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public final class JarHelper$
implements codacy.foundation.utils.Logger {
    public static final JarHelper$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JarHelper$();
    }

    private Logger logger$lzycompute() {
        JarHelper$ jarHelper$ = this;
        synchronized (jarHelper$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Seq<String> listResourceDirectory(String path) {
        Seq seq;
        URL dirURL = this.getClass().getClassLoader().getResource(path);
        if (Option$.MODULE$.apply((Object)dirURL).isDefined()) {
            String string = dirURL.getProtocol().toString();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                seq = FileSystemProviderBase$.MODULE$.listFiles(new File(dirURL.toURI()), FileSystemProviderBase$.MODULE$.listFiles$default$2(), FileSystemProviderBase$.MODULE$.listFiles$default$3());
                return seq;
            }
        }
        ArrayBuffer results = new ArrayBuffer();
        String string = dirURL.getProtocol().toString();
        String string3 = "jar";
        if (string != null ? !string.equals(string3) : string3 != null) {
            seq = (Seq)Seq$.MODULE$.empty();
            return seq;
        }
        String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
        JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
        Enumeration<JarEntry> entries = jar.entries();
        while (true) {
            BoxedUnit boxedUnit;
            if (!entries.hasMoreElements()) {
                seq = results.toSeq();
                return seq;
            }
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!entry.isDirectory() && name.startsWith(path)) {
                boxedUnit = results.$plus$eq(new StringOps(Predef$.MODULE$.augmentString(name)).diff((GenSeq)Predef$.MODULE$.wrapString(path)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getResourceContent(String path) {
        String string;
        URL file = this.getClass().getClassLoader().getResource(path);
        Codec codec = Codec$.MODULE$.apply("UTF-8");
        codec.onMalformedInput(CodingErrorAction.REPLACE);
        codec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        if (Option$.MODULE$.apply((Object)file).isDefined()) {
            String string2 = file.getProtocol().toString();
            String string3 = "file";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                string = ((TraversableOnce)FileContents$.MODULE$.getLines(new File(file.toURI())).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.empty();
                    }
                })).mkString("\n");
                return string;
            }
        }
        if (!Option$.MODULE$.apply((Object)file).isDefined()) return "";
        String string4 = file.getProtocol().toString();
        String string5 = "jar";
        if (string4 == null) {
            if (string5 != null) {
                return "";
            }
        } else if (!string4.equals(string5)) return "";
        InputStream iStream = file.openStream();
        try {
            string = Source$.MODULE$.fromInputStream(iStream, codec).mkString();
            return string;
        }
        catch (Throwable throwable) {
            try {
                String string6;
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error while getting resource content for {}: {}", (Object[])new String[]{path, e.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                string = string6 = "";
                return string;
            }
            finally {
                iStream.close();
            }
        }
    }

    private JarHelper$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

