/*
 * Decompiled with CFR 0.152.
 */
package codacy.foundation.files;

import codacy.foundation.files.FileSystemProviderBase$;
import codacy.foundation.files.JavaZipArchiveUtil;
import codacy.foundation.files.JavaZipArchiveUtil$;
import codacy.foundation.files.SymlinkFilter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class JavaZipArchiveUtil$
implements codacy.foundation.utils.Logger {
    public static final JavaZipArchiveUtil$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JavaZipArchiveUtil$();
    }

    private Logger logger$lzycompute() {
        JavaZipArchiveUtil$ javaZipArchiveUtil$ = this;
        synchronized (javaZipArchiveUtil$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public List<JavaZipArchiveUtil.ZipFileDescriptor> createFileList(File baseFile, Option<File> baseDirectory) {
        Nil$ nil$;
        File file = baseFile;
        if (file.isFile() && new SymlinkFilter().accept(file)) {
            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JavaZipArchiveUtil.ZipFileDescriptor[]{new JavaZipArchiveUtil.ZipFileDescriptor(file.getAbsoluteFile().toString(), ((File)baseDirectory.getOrElse((Function0)new Serializable(baseFile){
                public static final long serialVersionUID = 0L;
                private final File baseFile$1;

                public final File apply() {
                    return this.baseFile$1;
                }
                {
                    this.baseFile$1 = baseFile$1;
                }
            })).toString())}));
        } else if (file.isDirectory()) {
            Seq<String> fList = FileSystemProviderBase$.MODULE$.listFiles(file, FileSystemProviderBase$.MODULE$.listFiles$default$2(), FileSystemProviderBase$.MODULE$.listFiles$default$3());
            nil$ = (List)fList.foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(baseFile, baseDirectory, file){
                public static final long serialVersionUID = 0L;
                public final File baseFile$1;
                private final Option baseDirectory$1;
                private final File x1$1;

                public final List<JavaZipArchiveUtil.ZipFileDescriptor> apply(List<JavaZipArchiveUtil.ZipFileDescriptor> pList, String path) {
                    return (List)pList.$plus$plus(JavaZipArchiveUtil$.MODULE$.createFileList(new File(this.x1$1, path), (Option<File>)new Some(this.baseDirectory$1.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.createFileList.2 $outer;

                        public final File apply() {
                            return this.$outer.baseFile$1;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }))), List$.MODULE$.canBuildFrom());
                }
                {
                    this.baseFile$1 = baseFile$1;
                    this.baseDirectory$1 = baseDirectory$1;
                    this.x1$1 = x1$1;
                }
            });
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public Option<File> createFileList$default$2() {
        return None$.MODULE$;
    }

    public ZipEntry codacy$foundation$files$JavaZipArchiveUtil$$addFileToZipEntry(String filename, String parentPath, int filePathsCount) {
        ZipEntry zipEntry;
        if (filePathsCount <= 1) {
            zipEntry = new ZipEntry(new File(filename).getName());
        } else {
            String relative = new File(parentPath).toURI().relativize(new File(filename).toURI()).getPath();
            zipEntry = new ZipEntry(relative);
        }
        return zipEntry;
    }

    private void createZip(List<JavaZipArchiveUtil.ZipFileDescriptor> filePaths, OutputStream output) {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(output);
            filePaths.foreach((Function1)new Serializable(filePaths, zipOutputStream){
                public static final long serialVersionUID = 0L;
                private final List filePaths$1;
                private final ZipOutputStream zipOutputStream$1;

                public final long apply(JavaZipArchiveUtil.ZipFileDescriptor file) {
                    ZipEntry zipEntry = JavaZipArchiveUtil$.MODULE$.codacy$foundation$files$JavaZipArchiveUtil$$addFileToZipEntry(file.filename(), file.parentPath(), this.filePaths$1.size());
                    this.zipOutputStream$1.putNextEntry(zipEntry);
                    return Files.copy(new File(file.filename()).toPath(), this.zipOutputStream$1);
                }
                {
                    this.filePaths$1 = filePaths$1;
                    this.zipOutputStream$1 = zipOutputStream$1;
                }
            });
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Exception", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void createZipFile(List<JavaZipArchiveUtil.ZipFileDescriptor> filePaths, File file) {
        try {
            Object object = file.getParentFile().exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)file.getParentFile().mkdirs());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.createZip(filePaths, fileOutputStream);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Exception", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void unzip(File file, File destDir) {
        int dotIndex = file.getName().lastIndexOf(".") > 0 ? file.getName().lastIndexOf(".") : file.getName().length();
        String basename = file.getName().substring(0, dotIndex);
        Object object = destDir.exists() ? BoxesRunTime.boxToBoolean((boolean)destDir.delete()) : BoxedUnit.UNIT;
        destDir.mkdirs();
        ZipFile zip = new ZipFile(file);
        JavaConversions$.MODULE$.enumerationAsScalaIterator(zip.entries()).foreach((Function1)new Serializable(destDir, basename, zip){
            public static final long serialVersionUID = 0L;
            private final File destDir$1;
            private final String basename$1;
            private final ZipFile zip$1;

            public final long apply(ZipEntry entry) {
                Object object;
                String entryName = entry.getName();
                String entryPath = entryName.startsWith(this.basename$1) ? entryName.substring(this.basename$1.length()) : entryName;
                String[] splitPath = (String[])Predef$.MODULE$.refArrayOps((Object[])entry.getName().split(File.separator)).dropRight(1);
                if (Predef$.MODULE$.refArrayOps((Object[])splitPath).size() >= 1) {
                    StringBuilder dirBuilder = new StringBuilder(this.destDir$1.getAbsolutePath());
                    object = Predef$.MODULE$.refArrayOps((Object[])splitPath).foldLeft((Object)dirBuilder, (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * WARNING - void declaration
                         */
                        public final StringBuilder apply(StringBuilder a, String b) {
                            void var3_3;
                            StringBuilder path = a.append(new StringBuilder().append((Object)File.separator).append((Object)b).toString());
                            String str = path.mkString();
                            Object object = new File(str).exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)new File(str).mkdirs());
                            return var3_3;
                        }
                    });
                } else {
                    object = BoxedUnit.UNIT;
                }
                return Files.copy(this.zip$1.getInputStream(entry), new File(this.destDir$1, entryPath).toPath(), new CopyOption[0]);
            }
            {
                this.destDir$1 = destDir$1;
                this.basename$1 = basename$1;
                this.zip$1 = zip$1;
            }
        });
    }

    private JavaZipArchiveUtil$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

