package com.codacy.tracing.annotations

import scala.annotation.{compileTimeOnly, StaticAnnotation}
import scala.language.experimental.macros
import scala.reflect.macros.whitebox

@compileTimeOnly("Use macro paradise compiler plugin to expand macro annotations")
class Traced extends StaticAnnotation {
  def macroTransform(annottees: Any*): Any = macro TracedMacro.impl
}

object TracedMacro {

  def impl(c: whitebox.Context)(annottees: c.Expr[Any]*): c.Tree = {
    import c.universe._

    def wrapTraced(tname: TermName, body: Tree): Tree = {
      q"""com.codacy.tracing.GlobalRegistry.buildSpan(${c
        .Expr[String](Literal(Constant(c.internal.enclosingOwner.fullName.toString + "." + tname)))}).withSpan { $body }"""
    }

    annottees.map(_.tree) match {
      case q"$mods def $tname[..$tparams](...$paramss): $tpt = $expr" :: Nil =>
        q"""$mods def $tname[..$tparams](...$paramss): $tpt = ${wrapTraced(tname, expr)}"""

      case q"$mods def $tname[..$tparams](...$paramss) = $expr" :: Nil =>
        q"""$mods def $tname[..$tparams](...$paramss) = ${wrapTraced(tname, expr)}"""

      case _ =>
        c.abort(c.enclosingPosition, "Invalid annottee, only defs are allowed.")
    }
  }

}
