/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import com.comcast.ip4s.Cidr;
import com.comcast.ip4s.Hostname;
import com.comcast.ip4s.Hostname$;
import com.comcast.ip4s.IDN;
import com.comcast.ip4s.IDN$;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6Address$;
import com.comcast.ip4s.Multicast;
import com.comcast.ip4s.MulticastJoin;
import com.comcast.ip4s.MulticastJoin$;
import com.comcast.ip4s.MulticastSocketAddress;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SourceSpecificMulticast;
import java.io.Serializable;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Arbitraries$ {
    public static Arbitraries$ MODULE$;
    private final Gen<Ipv4Address> ipv4Generator;
    private final Arbitrary<Ipv4Address> ipv4Arbitrary;
    private final Gen<Ipv6Address> ipv6Generator;
    private final Arbitrary<Ipv6Address> ipv6Arbitrary;
    private final Gen<IpAddress> ipGenerator;
    private final Arbitrary<IpAddress> ipArbitrary;
    private final Gen<Port> portGenerator;
    private final Arbitrary<Port> portArbitrary;
    private final Gen<Multicast<Ipv4Address>> multicastGenerator4;
    private final Arbitrary<Multicast<Ipv4Address>> multicastArbitrary4;
    private final Gen<Multicast<Ipv6Address>> multicastGenerator6;
    private final Arbitrary<Multicast<Ipv6Address>> multicastArbitrary6;
    private final Gen<Multicast<IpAddress>> multicastGenerator;
    private final Arbitrary<Multicast<IpAddress>> multicastArbitrary;
    private final Gen<Hostname> hostnameGenerator;
    private final Arbitrary<Hostname> hostnameArbitrary;
    private final Gen<IDN> idnGenerator;
    private final Arbitrary<IDN> idnArbitrary;

    static {
        new Arbitraries$();
    }

    public Gen<Ipv4Address> ipv4Generator() {
        return this.ipv4Generator;
    }

    public Arbitrary<Ipv4Address> ipv4Arbitrary() {
        return this.ipv4Arbitrary;
    }

    public Gen<Ipv6Address> ipv6Generator() {
        return this.ipv6Generator;
    }

    public Arbitrary<Ipv6Address> ipv6Arbitrary() {
        return this.ipv6Arbitrary;
    }

    public Gen<IpAddress> ipGenerator() {
        return this.ipGenerator;
    }

    public Arbitrary<IpAddress> ipArbitrary() {
        return this.ipArbitrary;
    }

    public <A extends IpAddress> Gen<Cidr<A>> cidrGenerator(Gen<A> genIp) {
        return genIp.flatMap((Function1 & Serializable & scala.Serializable)ip -> {
            int bitLength = BoxesRunTime.unboxToInt(ip.fold((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Arbitraries$.$anonfun$cidrGenerator$2(x$1)), (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Arbitraries$.$anonfun$cidrGenerator$3(x$2))));
            return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)bitLength), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable & scala.Serializable)prefix -> ip.$div(BoxesRunTime.unboxToInt((Object)prefix)));
        });
    }

    public <A extends IpAddress> Arbitrary<Cidr<A>> cidrArbitrary(Arbitrary<A> arbIp) {
        return Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.cidrGenerator(arbIp.arbitrary()));
    }

    public Gen<Port> portGenerator() {
        return this.portGenerator;
    }

    public Arbitrary<Port> portArbitrary() {
        return this.portArbitrary;
    }

    public <A extends IpAddress> Gen<SocketAddress<A>> socketAddressGenerator(Gen<A> genIp, Gen<Port> genPort) {
        return genIp.flatMap((Function1 & Serializable & scala.Serializable)ip -> genPort.map((Function1 & Serializable & scala.Serializable)port -> new SocketAddress<IpAddress>((IpAddress)ip, (Port)port)));
    }

    public <A extends IpAddress> Arbitrary<SocketAddress<A>> socketAddressArbitrary(Arbitrary<A> arbIp, Arbitrary<Port> arbPort) {
        return Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.socketAddressGenerator(arbIp.arbitrary(), (Gen<Port>)arbPort.arbitrary()));
    }

    public Gen<Multicast<Ipv4Address>> multicastGenerator4() {
        return this.multicastGenerator4;
    }

    public Arbitrary<Multicast<Ipv4Address>> multicastArbitrary4() {
        return this.multicastArbitrary4;
    }

    public Gen<Multicast<Ipv6Address>> multicastGenerator6() {
        return this.multicastGenerator6;
    }

    public Arbitrary<Multicast<Ipv6Address>> multicastArbitrary6() {
        return this.multicastArbitrary6;
    }

    public Gen<Multicast<IpAddress>> multicastGenerator() {
        return this.multicastGenerator;
    }

    public Arbitrary<Multicast<IpAddress>> multicastArbitrary() {
        return this.multicastArbitrary;
    }

    public <A extends IpAddress> Gen<MulticastJoin<A>> multicastJoinGenerator(Gen<A> genSource, Gen<Multicast<A>> genGroup) {
        return genGroup.flatMap((Function1 & Serializable & scala.Serializable)group -> {
            Gen gen;
            Option<SourceSpecificMulticast<IpAddress>> option = ((IpAddress)group.address()).asSourceSpecificMulticast();
            if (option instanceof Some) {
                Some some = (Some)option;
                SourceSpecificMulticast grp = (SourceSpecificMulticast)some.value();
                gen = genSource.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Arbitraries$.$anonfun$multicastJoinGenerator$2(grp, x$5))).flatMap((Function1 & Serializable & scala.Serializable)src -> Gen$.MODULE$.const(MulticastJoin$.MODULE$.ssm(src, grp)));
            } else if (None$.MODULE$.equals(option)) {
                gen = Gen$.MODULE$.const(MulticastJoin$.MODULE$.asm(group));
            } else {
                throw new MatchError(option);
            }
            return gen;
        });
    }

    public <A extends IpAddress> Arbitrary<MulticastJoin<A>> multicastJoinArbitrary(Arbitrary<A> arbSource, Arbitrary<Multicast<A>> arbGroup) {
        return Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.multicastJoinGenerator(arbSource.arbitrary(), arbGroup.arbitrary()));
    }

    public <A extends IpAddress> Gen<MulticastSocketAddress<MulticastJoin, A>> multicastSocketAddressGenerator(Gen<MulticastJoin<A>> genJoin, Gen<Port> genPort) {
        return genJoin.flatMap((Function1 & Serializable & scala.Serializable)join -> genPort.map((Function1 & Serializable & scala.Serializable)port -> new MulticastSocketAddress((MulticastJoin)join, (Port)port)));
    }

    public <A extends IpAddress> Arbitrary<MulticastSocketAddress<MulticastJoin, A>> multicastSocketAddressArbitrary(Arbitrary<MulticastJoin<A>> arbJoin, Arbitrary<Port> arbPort) {
        return Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.multicastSocketAddressGenerator(arbJoin.arbitrary(), (Gen<Port>)arbPort.arbitrary()));
    }

    public Gen<Hostname> hostnameGenerator() {
        return this.hostnameGenerator;
    }

    public Arbitrary<Hostname> hostnameArbitrary() {
        return this.hostnameArbitrary;
    }

    public Gen<IDN> idnGenerator() {
        return this.idnGenerator;
    }

    public Arbitrary<IDN> idnArbitrary() {
        return this.idnArbitrary;
    }

    public static final /* synthetic */ int $anonfun$cidrGenerator$2(Ipv4Address x$1) {
        return 32;
    }

    public static final /* synthetic */ int $anonfun$cidrGenerator$3(Ipv6Address x$2) {
        return 128;
    }

    public static final /* synthetic */ Port $anonfun$portGenerator$1(int x$4) {
        return (Port)Port$.MODULE$.fromInt(x$4).get();
    }

    public static final /* synthetic */ boolean $anonfun$multicastJoinGenerator$2(SourceSpecificMulticast grp$1, IpAddress x$5) {
        Class<?> clazz = x$5.getClass();
        Class<?> clazz2 = grp$1.getClass();
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ Some $anonfun$hostnameGenerator$5(char x$7) {
        return new Some((Object)BoxesRunTime.boxToCharacter((char)x$7));
    }

    public static final /* synthetic */ String $anonfun$hostnameGenerator$8(char x$8) {
        return Character.toString(x$8);
    }

    public static final /* synthetic */ Gen $anonfun$hostnameGenerator$2(char first$1, int middleLen) {
        return Gen$.MODULE$.listOfN(middleLen, Gen$.MODULE$.oneOf(Gen$.MODULE$.alphaNumChar(), Gen$.MODULE$.const((Object)BoxesRunTime.boxToCharacter((char)'-')), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Gen[0]))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.mkString()).flatMap((Function1 & Serializable & scala.Serializable)middle -> (middleLen > 0 ? Gen$.MODULE$.alphaNumChar().map((Function1 & Serializable & scala.Serializable)x$7 -> Arbitraries$.$anonfun$hostnameGenerator$5(BoxesRunTime.unboxToChar((Object)x$7))) : Gen$.MODULE$.option(Gen$.MODULE$.alphaNumChar())).map((Function1 & Serializable & scala.Serializable)last -> new StringBuilder(0).append(Character.toString(first$1)).append((String)middle).append(last.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$8 -> Arbitraries$.$anonfun$hostnameGenerator$8(BoxesRunTime.unboxToChar((Object)x$8)))).toString()));
    }

    public static final /* synthetic */ Gen $anonfun$hostnameGenerator$1(char first) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)61), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable & scala.Serializable)middleLen -> Arbitraries$.$anonfun$hostnameGenerator$2(first, BoxesRunTime.unboxToInt((Object)middleLen)));
    }

    public static final /* synthetic */ int $anonfun$hostnameGenerator$11(int x$9, String x$10) {
        return x$9 + new StringOps(Predef$.MODULE$.augmentString(x$10)).size();
    }

    public static final /* synthetic */ boolean $anonfun$hostnameGenerator$10(int numLabels$1, List labels) {
        return BoxesRunTime.unboxToInt((Object)labels.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToInteger((int)Arbitraries$.$anonfun$hostnameGenerator$11(BoxesRunTime.unboxToInt((Object)x$9), x$10)))) < 253 - (numLabels$1 - 1);
    }

    public static final /* synthetic */ Gen $anonfun$hostnameGenerator$9(Gen genLabel$1, int numLabels) {
        return Gen$.MODULE$.listOfN(numLabels, genLabel$1).withFilter((Function1 & Serializable & scala.Serializable)labels -> BoxesRunTime.boxToBoolean((boolean)Arbitraries$.$anonfun$hostnameGenerator$10(numLabels, labels))).map((Function1 & Serializable & scala.Serializable)labels -> (Hostname)Hostname$.MODULE$.fromString(labels.mkString(".")).get());
    }

    public static final /* synthetic */ Some $anonfun$idnGenerator$5(char x$12) {
        return new Some((Object)BoxesRunTime.boxToCharacter((char)x$12));
    }

    public static final /* synthetic */ String $anonfun$idnGenerator$8(char x$13) {
        return Character.toString(x$13);
    }

    public static final /* synthetic */ boolean $anonfun$idnGenerator$9(Tuple2 x$14) {
        Tuple2 tuple2 = x$14;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String str = (String)tuple2._2();
        boolean bl = Option$.MODULE$.option2Iterable(IDN$.MODULE$.toAscii(str)).size() < 64;
        return bl;
    }

    public static final /* synthetic */ Gen $anonfun$idnGenerator$2(Gen genChar$1, char first$2, int middleLen) {
        return Gen$.MODULE$.listOfN(middleLen, Gen$.MODULE$.oneOf(genChar$1, Gen$.MODULE$.const((Object)BoxesRunTime.boxToCharacter((char)'-')), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Gen[0]))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.mkString()).flatMap((Function1 & Serializable & scala.Serializable)middle -> (middleLen > 0 ? genChar$1.map((Function1 & Serializable & scala.Serializable)x$12 -> Arbitraries$.$anonfun$idnGenerator$5(BoxesRunTime.unboxToChar((Object)x$12))) : Gen$.MODULE$.option(genChar$1)).map((Function1 & Serializable & scala.Serializable)last -> {
            String str = new StringBuilder(0).append(Character.toString(first$2)).append((String)middle).append(last.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$13 -> Arbitraries$.$anonfun$idnGenerator$8(BoxesRunTime.unboxToChar((Object)x$13)))).toString();
            return new Tuple2(last, (Object)str);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)Arbitraries$.$anonfun$idnGenerator$9(x$14))).map((Function1 & Serializable & scala.Serializable)x$15 -> {
            String str;
            Tuple2 tuple2 = x$15;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = str = (String)tuple2._2();
            return string;
        }));
    }

    public static final /* synthetic */ Gen $anonfun$idnGenerator$1(Gen genChar$1, char first) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)61), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable & scala.Serializable)middleLen -> Arbitraries$.$anonfun$idnGenerator$2(genChar$1, first, BoxesRunTime.unboxToInt((Object)middleLen)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$idnGenerator$13(List labels$1, char dot) {
        Option<IDN> idn = IDN$.MODULE$.fromString(labels$1.mkString(Character.toString(dot)));
        return new Tuple2((Object)BoxesRunTime.boxToCharacter((char)dot), idn);
    }

    public static final /* synthetic */ boolean $anonfun$idnGenerator$14(Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option idn = (Option)tuple2._2();
        boolean bl = idn.isDefined();
        return bl;
    }

    public static final /* synthetic */ Gen $anonfun$idnGenerator$11(Gen genLabel$2, int numLabels) {
        return Gen$.MODULE$.listOfN(numLabels, genLabel$2).flatMap((Function1 & Serializable & scala.Serializable)labels -> Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToCharacter((char)'.'), (Object)BoxesRunTime.boxToCharacter((char)'.'), (Seq)Predef$.MODULE$.wrapCharArray(new char[]{'\u3002', '\uff0e', '\uff61'})).map((Function1 & Serializable & scala.Serializable)dot -> Arbitraries$.$anonfun$idnGenerator$13(labels, BoxesRunTime.unboxToChar((Object)dot))).withFilter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)Arbitraries$.$anonfun$idnGenerator$14(x$16))).map((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple2 tuple2 = x$17;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option idn = (Option)tuple2._2();
            IDN iDN = (IDN)idn.get();
            return iDN;
        }));
    }

    private Arbitraries$() {
        MODULE$ = this;
        this.ipv4Generator = Gen$.MODULE$.listOfN(4, Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbByte())).map((Function1 & Serializable & scala.Serializable)bytes -> (Ipv4Address)Ipv4Address$.MODULE$.fromBytes((byte[])bytes.toArray(ClassTag$.MODULE$.Byte())).get());
        this.ipv4Arbitrary = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.ipv4Generator());
        this.ipv6Generator = Gen$.MODULE$.listOfN(16, Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbByte())).map((Function1 & Serializable & scala.Serializable)bytes -> (Ipv6Address)Ipv6Address$.MODULE$.fromBytes((byte[])bytes.toArray(ClassTag$.MODULE$.Byte())).get());
        this.ipv6Arbitrary = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.ipv6Generator());
        this.ipGenerator = Gen$.MODULE$.oneOf(this.ipv4Generator(), this.ipv6Generator(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Gen[0]));
        this.ipArbitrary = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.ipGenerator());
        this.portGenerator = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)65535), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable & scala.Serializable)x$4 -> Arbitraries$.$anonfun$portGenerator$1(BoxesRunTime.unboxToInt((Object)x$4)));
        this.portArbitrary = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.portGenerator());
        this.multicastGenerator4 = this.ipv4Generator().map((Function1 & Serializable & scala.Serializable)ip -> (Multicast)Ipv4Address$.MODULE$.fromLong(ip.toLong() & (long)(~-268435456) | 0xFFFFFFFFE0000000L).asMulticast().get());
        this.multicastArbitrary4 = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.multicastGenerator4());
        this.multicastGenerator6 = this.ipv6Generator().map((Function1 & Serializable & scala.Serializable)ip -> (Multicast)Ipv6Address$.MODULE$.fromBigInt(ip.toBigInt().$amp(package$.MODULE$.BigInt().apply(255).$less$less(120).unary_$tilde()).$bar(package$.MODULE$.BigInt().apply(255).$less$less(120))).asMulticast().get());
        this.multicastArbitrary6 = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.multicastGenerator6());
        this.multicastGenerator = Gen$.MODULE$.oneOf(this.multicastGenerator4(), this.multicastGenerator6(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Gen[0]));
        this.multicastArbitrary = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.multicastGenerator());
        Gen genLabel = Gen$.MODULE$.alphaNumChar().flatMap((Function1 & Serializable & scala.Serializable)first -> Arbitraries$.$anonfun$hostnameGenerator$1(BoxesRunTime.unboxToChar((Object)first)));
        this.hostnameGenerator = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable & scala.Serializable)numLabels -> Arbitraries$.$anonfun$hostnameGenerator$9(genLabel, BoxesRunTime.unboxToInt((Object)numLabels)));
        this.hostnameArbitrary = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.hostnameGenerator());
        Gen genChar = Gen$.MODULE$.oneOf(Gen$.MODULE$.alphaNumChar(), Gen$.MODULE$.const((Object)BoxesRunTime.boxToCharacter((char)'\u03b4')), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Gen[]{Gen$.MODULE$.const((Object)BoxesRunTime.boxToCharacter((char)'\u03c0')), Gen$.MODULE$.const((Object)BoxesRunTime.boxToCharacter((char)'\u03b8'))}));
        Gen genLabel2 = genChar.flatMap((Function1 & Serializable & scala.Serializable)first -> Arbitraries$.$anonfun$idnGenerator$1(genChar, BoxesRunTime.unboxToChar((Object)first)));
        this.idnGenerator = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable & scala.Serializable)numLabels -> Arbitraries$.$anonfun$idnGenerator$11(genLabel2, BoxesRunTime.unboxToInt((Object)numLabels)));
        this.idnArbitrary = Arbitrary$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.idnGenerator());
    }
}

