/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.xfinity.sirius.api.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.comcast.xfinity.sirius.admin.ObjectNameHelper;
import com.comcast.xfinity.sirius.api.RequestHandler;
import com.comcast.xfinity.sirius.api.SiriusConfiguration;
import com.comcast.xfinity.sirius.api.impl.SiriusFactory$;
import com.comcast.xfinity.sirius.api.impl.SiriusImpl;
import com.comcast.xfinity.sirius.api.impl.SiriusImpl$;
import com.comcast.xfinity.sirius.info.SiriusInfo;
import com.comcast.xfinity.sirius.uberstore.UberStore$;
import com.comcast.xfinity.sirius.uberstore.segmented.SegmentedUberStore$;
import com.comcast.xfinity.sirius.util.AkkaExternalAddressResolver;
import com.comcast.xfinity.sirius.util.AkkaExternalAddressResolver$;
import com.comcast.xfinity.sirius.writeaheadlog.CachedSiriusLog$;
import com.comcast.xfinity.sirius.writeaheadlog.SiriusLog;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SiriusFactory$ {
    public static final SiriusFactory$ MODULE$;
    private final Logger traceLog;

    static {
        new SiriusFactory$();
    }

    public Logger traceLog() {
        return this.traceLog;
    }

    public SiriusImpl createInstance(RequestHandler requestHandler, SiriusConfiguration siriusConfig) {
        Option option = siriusConfig.getProp("sirius.uberstore.dir");
        if (option instanceof Some) {
            SiriusLog siriusLog;
            String string;
            String dir;
            String string2;
            Some some = (Some)option;
            String uberStoreDir = string2 = (dir = (String)some.x());
            String string3 = string = (String)siriusConfig.getProp("sirius.uberstore.impl-version-id", new anonfun.5());
            String string4 = SegmentedUberStore$.MODULE$.versionId();
            SiriusLog siriusLog2 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? SegmentedUberStore$.MODULE$.apply(uberStoreDir, siriusConfig) : UberStore$.MODULE$.apply(uberStoreDir);
            SiriusLog backendLog = siriusLog2;
            if (BoxesRunTime.unboxToBoolean(siriusConfig.getProp("sirius.log.write-cache-enabled", new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return true;
                }
            }))) {
                int cacheSize = BoxesRunTime.unboxToInt(siriusConfig.getProp("sirius.log.write-cache-size", new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 10000;
                    }
                }));
                siriusLog = CachedSiriusLog$.MODULE$.apply(backendLog, cacheSize);
            } else {
                siriusLog = backendLog;
            }
            SiriusLog log = siriusLog;
            return this.createInstance(requestHandler, siriusConfig, log);
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalArgumentException("sirius.uberstore.dir must be set on config");
        }
        throw new MatchError(option);
    }

    public SiriusImpl createInstance(RequestHandler requestHandler, SiriusConfiguration siriusConfig, SiriusLog siriusLog) {
        String systemName = (String)siriusConfig.getProp("sirius.akka.actor-system.name", new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "sirius-system";
            }
        });
        ActorSystem actorSystem = ActorSystem$.MODULE$.apply(systemName, this.createActorSystemConfig(siriusConfig));
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        siriusConfig.setProp("sirius.monitoring.mbean-server", mbeanServer);
        siriusConfig.setProp("sirius.akka.external-address-resolver", AkkaExternalAddressResolver$.MODULE$.apply(actorSystem, siriusConfig));
        SiriusImpl impl = SiriusImpl$.MODULE$.apply(requestHandler, siriusLog, siriusConfig, actorSystem);
        Tuple2<ObjectName, SiriusInfo> tuple2 = this.createSiriusInfoMBean(actorSystem, impl.supervisor(), siriusConfig);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ObjectName siriusInfoObjectName = (ObjectName)tuple2._1();
            SiriusInfo siriusInfo = (SiriusInfo)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)siriusInfoObjectName, (Object)siriusInfo);
            ObjectName siriusInfoObjectName2 = (ObjectName)tuple23._1();
            SiriusInfo siriusInfo2 = (SiriusInfo)tuple23._2();
            mbeanServer.registerMBean(siriusInfo2, siriusInfoObjectName2);
            impl.onShutdown((Function0<BoxedUnit>)new Serializable(actorSystem, mbeanServer, siriusInfoObjectName2){
                public static final long serialVersionUID = 0L;
                private final ActorSystem actorSystem$1;
                private final MBeanServer mbeanServer$1;
                private final ObjectName siriusInfoObjectName$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.actorSystem$1.shutdown();
                    this.actorSystem$1.awaitTermination();
                    this.mbeanServer$1.unregisterMBean(this.siriusInfoObjectName$1);
                }
                {
                    this.actorSystem$1 = actorSystem$1;
                    this.mbeanServer$1 = mbeanServer$1;
                    this.siriusInfoObjectName$1 = siriusInfoObjectName$1;
                }
            });
            return impl;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<ObjectName, SiriusInfo> createSiriusInfoMBean(ActorSystem actorSystem, ActorRef siriusSup, SiriusConfiguration siriusConfig) {
        AkkaExternalAddressResolver resolver = (AkkaExternalAddressResolver)siriusConfig.getProp("sirius.akka.external-address-resolver").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("SiriusConfiguration.AKKA_EXTERNAL_ADDRESS_RESOLVER returned nothing");
            }
        });
        SiriusInfo siriusInfo = new SiriusInfo(actorSystem, siriusSup, resolver);
        ObjectNameHelper objectNameHelper = new ObjectNameHelper();
        ObjectName siriusInfoObjectName = objectNameHelper.getObjectName(siriusInfo, siriusSup, actorSystem, siriusConfig);
        return new Tuple2((Object)siriusInfoObjectName, (Object)siriusInfo);
    }

    private Config createActorSystemConfig(SiriusConfiguration siriusConfig) {
        Config hostPortConfig = this.createHostPortConfig(siriusConfig);
        Config externalConfig = this.createExternalConfig(siriusConfig);
        Config baseAkkaConfig = ConfigFactory.load((String)"sirius-akka-base.conf");
        return hostPortConfig.withFallback((ConfigMergeable)externalConfig).withFallback((ConfigMergeable)baseAkkaConfig);
    }

    private Config createHostPortConfig(SiriusConfiguration siriusConfig) {
        Object object;
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        boolean sslEnabled = BoxesRunTime.unboxToBoolean(siriusConfig.getProp("sirius.akka.ssl", new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        String transportPrefix = sslEnabled ? "akka.remote.netty.ssl" : "akka.remote.netty.tcp";
        this.traceLog().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AKKA using transport: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})));
        configMap.put("akka.remote.enabled-transports", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{transportPrefix}))).asJava());
        configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".hostname"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.host", new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return InetAddress.getLocalHost().getHostName();
            }
        }));
        configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".port"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.port", new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 2552;
            }
        }));
        int maxMessageSize = siriusConfig.getInt("sirius.akka.maximum-frame-size-kb", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1024;
            }
        });
        int bufferSize = maxMessageSize * 2;
        configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".maximum-frame-size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "k"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxMessageSize)})));
        configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".send-buffer-size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "k"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bufferSize)})));
        configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".receive-buffer-size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "k"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bufferSize)})));
        if (sslEnabled) {
            configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".random-number-generator"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.ssl.rng", new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
            configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".security.key-store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.ssl.key-store.location", new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("No key-store provided");
                }
            }));
            configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".security.trust-store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.ssl.trust-store.location", new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("No trust-store provided");
                }
            }));
            configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".security.key-store-password"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.ssl.key-store.password", new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("No key-store-password value provided");
                }
            }));
            configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".security.key-password"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.ssl.key.password", new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("No key-password value provided");
                }
            }));
            object = configMap.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".security.trust-store-password"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transportPrefix})), siriusConfig.getProp("sirius.akka.ssl.trust-store.password", new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("No trust-store-password value provided");
                }
            }));
        } else {
            object = BoxedUnit.UNIT;
        }
        return ConfigFactory.parseMap(configMap);
    }

    private Config createExternalConfig(SiriusConfiguration siriusConfig) {
        Option option;
        block4: {
            Config config;
            block3: {
                block2: {
                    option = siriusConfig.getProp("sirius.akka.system-config-overrides");
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    config = ConfigFactory.empty();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String externConfig = (String)some.x();
                File externConfigFile = new File(externConfig);
                config = externConfigFile.exists() ? ConfigFactory.parseFile((File)externConfigFile).resolve() : ConfigFactory.parseResources((String)externConfig).resolve();
            }
            return config;
        }
        throw new MatchError(option);
    }

    private SiriusFactory$() {
        MODULE$ = this;
        this.traceLog = LoggerFactory.getLogger((String)"SiriusFactory");
    }
}

