/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.xfinity.sirius.tool;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.routing.RoundRobinRouter;
import akka.routing.RoundRobinRouter$;
import akka.routing.RouterConfig;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.comcast.xfinity.sirius.api.SiriusConfiguration;
import com.comcast.xfinity.sirius.api.impl.Delete;
import com.comcast.xfinity.sirius.api.impl.NonCommutativeSiriusRequest;
import com.comcast.xfinity.sirius.api.impl.OrderedEvent;
import com.comcast.xfinity.sirius.api.impl.Put;
import com.comcast.xfinity.sirius.tool.WalTool;
import com.comcast.xfinity.sirius.tool.format.OrderedEventFormatter$;
import com.comcast.xfinity.sirius.uberstore.UberStore;
import com.comcast.xfinity.sirius.uberstore.UberStore$;
import com.comcast.xfinity.sirius.uberstore.UberTool$;
import com.comcast.xfinity.sirius.uberstore.segmented.SegmentedUberStore;
import com.comcast.xfinity.sirius.uberstore.segmented.SegmentedUberStore$;
import com.comcast.xfinity.sirius.writeaheadlog.SiriusLog;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import scala.Array$;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.util.matching.Regex;

public final class WalTool$ {
    public static final WalTool$ MODULE$;

    static {
        new WalTool$();
    }

    private void printUsage() {
        Console$.MODULE$.err().println("Usage:");
        Console$.MODULE$.err().println("   compact [two-pass] <inWalDir> <outWalDir>");
        Console$.MODULE$.err().println("       Compact UberStore in inWalDir into new UberStore in outWalDir");
        Console$.MODULE$.err().println("       If two-pass is provided then the more memory efficient two pass");
        Console$.MODULE$.err().println("       compaction algorithm will be used.  All deletes older than 1 week");
        Console$.MODULE$.err().println("       are fully removed from the resultant log. Will error if called");
        Console$.MODULE$.err().println("       against a SegmentedUberStore.");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   compact-segmented <walDir>");
        Console$.MODULE$.err().println("       Compact SegmentedUberStore in walDir. Will error if called against");
        Console$.MODULE$.err().println("       a non-segmented UberStore.");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   tail [-n number] <walDir>");
        Console$.MODULE$.err().println("       Show last 20 sequence numbers in wal.");
        Console$.MODULE$.err().println("       -n: number of lines to show (e.g., -n 10, -n 50), defaults to 20");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   range <begin> <end> <walDir>");
        Console$.MODULE$.err().println("       Show all entries in begin to end range, inclusive");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   key-filter <regexp> <inWalDir> <outWalDir>");
        Console$.MODULE$.err().println("       Write all OrderedEvents in UberStore in inWalDir having a key");
        Console$.MODULE$.err().println("       matching regexp to new UberStore in outWalDir");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   key-filter-not <regexp> <inWalDir> <outWalDir>");
        Console$.MODULE$.err().println("       Same as key-filter, except the resulting UberStore contains all");
        Console$.MODULE$.err().println("       OrderedEvents not matching regexp");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   key-list <inWalDir> <outFile>");
        Console$.MODULE$.err().println("       Write all keys from wal in outFile");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   key-list-filter <regexp> <inWalDir> <outFile>");
        Console$.MODULE$.err().println("       write all keys that match regexp to outFile");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   replay <inWalDir> <host> <concurrency>");
        Console$.MODULE$.err().println("       For each OrderedEvent will issue an http request");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   convert-to-segmented <inWalDir> <outWalDir> <segmentSize>");
        Console$.MODULE$.err().println("       Convert a LegacyUberStore into a SegmentedUberStore.");
        Console$.MODULE$.err().println("       SegmentSize is the number of entries to write per segment, and is required.");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   convert-to-legacy <inWalDir> <outWalDir>");
        Console$.MODULE$.err().println("       Convert a SegmentedUberStore into a LegacyUberStore");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   is-segmented <walDir>");
        Console$.MODULE$.err().println("       Returns 0 if the specified walDir is a segmented UberStore, 1 otherwise");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   is-legacy <walDir>");
        Console$.MODULE$.err().println("       Returns 0 if the specified walDir is a legacy UberStore, 1 otherwise");
        Console$.MODULE$.err().println();
        Console$.MODULE$.err().println("   init-segmented <walDir>");
        Console$.MODULE$.err().println("       Initialize a new SegmentedUberStore at walDir. Creates the necessary");
        Console$.MODULE$.err().println("       space and marks it appropriately.");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void main(String[] args) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option option5;
        Option option6;
        Option option7;
        Option option8;
        Option option9;
        Option option10;
        Option option11;
        Option option12;
        Option option13;
        Option option14;
        Option option15;
        String[] stringArray = args;
        Option option16 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option16.isEmpty() && option16.get() != null && ((SeqLike)option16.get()).lengthCompare(3) == 0) {
            String string = (String)((SeqLike)option16.get()).apply(0);
            String inWalDirName = (String)((SeqLike)option16.get()).apply(1);
            String outWalDirName = (String)((SeqLike)option16.get()).apply(2);
            String string2 = string;
            if ("compact".equals(string2)) {
                this.compact(inWalDirName, outWalDirName, false);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option15 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option15.get() != null && ((SeqLike)option15.get()).lengthCompare(4) == 0) {
            String string;
            String string3 = (String)((SeqLike)option15.get()).apply(0);
            String string4 = (String)((SeqLike)option15.get()).apply(1);
            String inWalDirName = (String)((SeqLike)option15.get()).apply(2);
            String outWalDirName = (String)((SeqLike)option15.get()).apply(3);
            String string5 = string3;
            if ("compact".equals(string5) && "two-pass".equals(string = string4)) {
                this.compact(inWalDirName, outWalDirName, true);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option14 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option14.get() != null && ((SeqLike)option14.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option14.get()).apply(0);
            String walDirName = (String)((SeqLike)option14.get()).apply(1);
            String string6 = string;
            if ("compact-segmented".equals(string6)) {
                this.compactSegmented(walDirName);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option13 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option13.get() != null && ((SeqLike)option13.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option13.get()).apply(0);
            String walDir = (String)((SeqLike)option13.get()).apply(1);
            String string7 = string;
            if ("tail".equals(string7)) {
                this.tailUber(walDir, this.tailUber$default$2());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option12 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option12.get() != null && ((SeqLike)option12.get()).lengthCompare(4) == 0) {
            String string;
            String string8 = (String)((SeqLike)option12.get()).apply(0);
            String string9 = (String)((SeqLike)option12.get()).apply(1);
            String number = (String)((SeqLike)option12.get()).apply(2);
            String walDir = (String)((SeqLike)option12.get()).apply(3);
            String string10 = string8;
            if ("tail".equals(string10) && "-n".equals(string = string9)) {
                this.tailUber(walDir, new StringOps(Predef$.MODULE$.augmentString(number)).toInt());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option11 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option11.get() != null && ((SeqLike)option11.get()).lengthCompare(4) == 0) {
            String string = (String)((SeqLike)option11.get()).apply(0);
            String begin = (String)((SeqLike)option11.get()).apply(1);
            String end = (String)((SeqLike)option11.get()).apply(2);
            String walDir = (String)((SeqLike)option11.get()).apply(3);
            String string11 = string;
            if ("range".equals(string11)) {
                this.printSeq(this.siriusLog(walDir), new StringOps(Predef$.MODULE$.augmentString(begin)).toLong(), new StringOps(Predef$.MODULE$.augmentString(end)).toLong());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option10 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option10.get() != null && ((SeqLike)option10.get()).lengthCompare(4) == 0) {
            String string = (String)((SeqLike)option10.get()).apply(0);
            String regexpStr = (String)((SeqLike)option10.get()).apply(1);
            String inWal = (String)((SeqLike)option10.get()).apply(2);
            String outWal = (String)((SeqLike)option10.get()).apply(3);
            String string12 = string;
            if ("key-filter".equals(string12)) {
                Regex regexp = new StringOps(Predef$.MODULE$.augmentString(regexpStr)).r();
                Serializable filterFun = new Serializable(regexp){
                    public static final long serialVersionUID = 0L;
                    private final Regex regexp$1;

                    public final boolean apply(OrderedEvent x$1) {
                        return WalTool$.MODULE$.com$comcast$xfinity$sirius$tool$WalTool$$keyMatch(this.regexp$1, x$1);
                    }
                    {
                        this.regexp$1 = regexp$1;
                    }
                };
                this.filter(inWal, outWal, (Function1<OrderedEvent, Object>)filterFun);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option9 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option9.get() != null && ((SeqLike)option9.get()).lengthCompare(4) == 0) {
            String string = (String)((SeqLike)option9.get()).apply(0);
            String regexpStr = (String)((SeqLike)option9.get()).apply(1);
            String inWal = (String)((SeqLike)option9.get()).apply(2);
            String outWal = (String)((SeqLike)option9.get()).apply(3);
            String string13 = string;
            if ("key-filter-not".equals(string13)) {
                Regex regexp = new StringOps(Predef$.MODULE$.augmentString(regexpStr)).r();
                Serializable filterFun = new Serializable(regexp){
                    public static final long serialVersionUID = 0L;
                    private final Regex regexp$2;

                    public final boolean apply(OrderedEvent x$2) {
                        return !WalTool$.MODULE$.com$comcast$xfinity$sirius$tool$WalTool$$keyMatch(this.regexp$2, x$2);
                    }
                    {
                        this.regexp$2 = regexp$2;
                    }
                };
                this.filter(inWal, outWal, (Function1<OrderedEvent, Object>)filterFun);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option8 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option8.get() != null && ((SeqLike)option8.get()).lengthCompare(3) == 0) {
            String string = (String)((SeqLike)option8.get()).apply(0);
            String inWal = (String)((SeqLike)option8.get()).apply(1);
            String outFile = (String)((SeqLike)option8.get()).apply(2);
            String string14 = string;
            if ("key-list".equals(string14)) {
                this.keyList(inWal, outFile);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option7 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option7.get() != null && ((SeqLike)option7.get()).lengthCompare(4) == 0) {
            String string = (String)((SeqLike)option7.get()).apply(0);
            String regexpStr = (String)((SeqLike)option7.get()).apply(1);
            String inWal = (String)((SeqLike)option7.get()).apply(2);
            String outFile = (String)((SeqLike)option7.get()).apply(3);
            String string15 = string;
            if ("key-list-filter".equals(string15)) {
                Regex regexp = new StringOps(Predef$.MODULE$.augmentString(regexpStr)).r();
                Serializable filterFun = new Serializable(regexp){
                    public static final long serialVersionUID = 0L;
                    private final Regex regexp$3;

                    public final boolean apply(OrderedEvent x$3) {
                        return WalTool$.MODULE$.com$comcast$xfinity$sirius$tool$WalTool$$keyMatch(this.regexp$3, x$3);
                    }
                    {
                        this.regexp$3 = regexp$3;
                    }
                };
                this.keyListFilter(inWal, outFile, (Function1<OrderedEvent, Object>)filterFun);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option6 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option6.get() != null && ((SeqLike)option6.get()).lengthCompare(4) == 0) {
            String string = (String)((SeqLike)option6.get()).apply(0);
            String inWal = (String)((SeqLike)option6.get()).apply(1);
            String host = (String)((SeqLike)option6.get()).apply(2);
            String concurrency = (String)((SeqLike)option6.get()).apply(3);
            String string16 = string;
            if ("replay".equals(string16)) {
                this.replay(inWal, host, new StringOps(Predef$.MODULE$.augmentString(concurrency)).toInt());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option5 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option5.get() != null && ((SeqLike)option5.get()).lengthCompare(4) == 0) {
            String string = (String)((SeqLike)option5.get()).apply(0);
            String inWal = (String)((SeqLike)option5.get()).apply(1);
            String outWal = (String)((SeqLike)option5.get()).apply(2);
            String segmentSize = (String)((SeqLike)option5.get()).apply(3);
            String string17 = string;
            if ("convert-to-segmented".equals(string17)) {
                this.convertToSegmented(inWal, outWal, new StringOps(Predef$.MODULE$.augmentString(segmentSize)).toLong());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option4 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option4.get() != null && ((SeqLike)option4.get()).lengthCompare(3) == 0) {
            String string = (String)((SeqLike)option4.get()).apply(0);
            String inWal = (String)((SeqLike)option4.get()).apply(1);
            String outWal = (String)((SeqLike)option4.get()).apply(2);
            String string18 = string;
            if ("convert-to-legacy".equals(string18)) {
                this.convertToLegacy(inWal, outWal);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option3 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option3.get()).apply(0);
            String wal = (String)((SeqLike)option3.get()).apply(1);
            String string19 = string;
            if ("is-segmented".equals(string19)) {
                if (!UberTool$.MODULE$.isSegmented(wal)) throw scala.sys.package$.MODULE$.exit(1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option2 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option2.get()).apply(0);
            String wal = (String)((SeqLike)option2.get()).apply(1);
            String string20 = string;
            if ("is-legacy".equals(string20)) {
                if (!UberTool$.MODULE$.isLegacy(wal)) throw scala.sys.package$.MODULE$.exit(1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        if (!(option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option.get()).apply(0);
            String walDir = (String)((SeqLike)option.get()).apply(1);
            String string21 = string;
            if ("init-segmented".equals(string21)) {
                this.initSegmented(walDir);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw scala.sys.package$.MODULE$.exit(0);
            }
        }
        this.printUsage();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        throw scala.sys.package$.MODULE$.exit(0);
    }

    private void compactSegmented(String walDirName) {
        SegmentedUberStore uberstore = SegmentedUberStore$.MODULE$.apply(walDirName, SegmentedUberStore$.MODULE$.apply$default$2());
        uberstore.compact();
    }

    private void compact(String inWalDirName, String outWalDirName, boolean twoPass) {
        this.createFreshDir(outWalDirName);
        UberStore inWal = UberStore$.MODULE$.apply(inWalDirName);
        UberStore outWal = UberStore$.MODULE$.apply(outWalDirName);
        this.doCompact(inWal, outWal, twoPass);
    }

    private void doCompact(SiriusLog inWal, SiriusLog outWal, boolean twoPass) {
        long cutoff;
        long maxDeleteAge = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("maxDeleteAge", "604800000"))).toLong();
        long l = cutoff = maxDeleteAge <= 0L ? 0L : System.currentTimeMillis() - maxDeleteAge;
        if (twoPass) {
            UberTool$.MODULE$.twoPassCompact(inWal, outWal, cutoff);
        } else {
            UberTool$.MODULE$.compact(inWal, outWal, cutoff);
        }
    }

    private void createFreshDir(String dirName) {
        File dir = new File(dirName);
        if (dir.exists()) {
            throw new Exception(new StringBuilder().append((Object)dirName).append((Object)" already exists").toString());
        }
        if (dir.mkdir()) {
            return;
        }
        throw new Exception(new StringBuilder().append((Object)"Failed to create ").append((Object)dirName).toString());
    }

    private void tailUber(String inDirName, int number) {
        SiriusLog wal = this.siriusLog(inDirName);
        long seq = wal.getNextSeq() - 1L;
        this.printSeq(wal, seq - (long)number, seq);
    }

    private int tailUber$default$2() {
        return 20;
    }

    private void printSeq(SiriusLog wal, long first, long last) {
        wal.foldLeftRange(first, last, BoxedUnit.UNIT, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(BoxedUnit x$4, OrderedEvent event) {
                OrderedEventFormatter$.MODULE$.printEvent(event);
            }
        });
    }

    public boolean com$comcast$xfinity$sirius$tool$WalTool$$keyMatch(Regex r, OrderedEvent evt) {
        NonCommutativeSiriusRequest nonCommutativeSiriusRequest;
        boolean bl;
        NonCommutativeSiriusRequest nonCommutativeSiriusRequest2;
        OrderedEvent orderedEvent = evt;
        if (orderedEvent != null && (nonCommutativeSiriusRequest2 = orderedEvent.request()) instanceof Put) {
            Put put = (Put)nonCommutativeSiriusRequest2;
            String key = put.key();
            Option option = r.findFirstIn((CharSequence)key);
            None$ none$ = None$.MODULE$;
            bl = option != null ? !option.equals(none$) : none$ != null;
        } else if (orderedEvent != null && (nonCommutativeSiriusRequest = orderedEvent.request()) instanceof Delete) {
            Delete delete = (Delete)nonCommutativeSiriusRequest;
            String key = delete.key();
            Option option = r.findFirstIn((CharSequence)key);
            None$ none$ = None$.MODULE$;
            bl = option != null ? !option.equals(none$) : none$ != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private void keyList(String inWal, String outFile) {
        SiriusLog wal = this.siriusLog(inWal);
        Set keySet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        wal.foreach(new Serializable(keySet){
            public static final long serialVersionUID = 0L;
            private final Set keySet$1;

            public final Set<WrappedArray<Object>> apply(OrderedEvent x$5) {
                NonCommutativeSiriusRequest nonCommutativeSiriusRequest;
                block4: {
                    Set set;
                    block3: {
                        block2: {
                            nonCommutativeSiriusRequest = x$5.request();
                            if (!(nonCommutativeSiriusRequest instanceof Put)) break block2;
                            Put put = (Put)nonCommutativeSiriusRequest;
                            set = (Set)this.keySet$1.$plus$eq((Object)WrappedArray$.MODULE$.make((Object)put.key().getBytes()));
                            break block3;
                        }
                        if (!(nonCommutativeSiriusRequest instanceof Delete)) break block4;
                        Delete delete = (Delete)nonCommutativeSiriusRequest;
                        set = (Set)this.keySet$1.$minus$eq((Object)WrappedArray$.MODULE$.make((Object)delete.key().getBytes()));
                    }
                    return set;
                }
                throw new MatchError((Object)nonCommutativeSiriusRequest);
            }
            {
                this.keySet$1 = keySet$1;
            }
        });
        PrintWriter out = new PrintWriter(outFile, "UTF-8");
        try {
            keySet.foreach((Function1)new Serializable(out){
                public static final long serialVersionUID = 0L;
                private final PrintWriter out$1;

                public final void apply(WrappedArray<Object> key) {
                    this.out$1.println(new String((byte[])key.toArray(ClassTag$.MODULE$.Byte())));
                }
                {
                    this.out$1 = out$1;
                }
            });
            return;
        }
        finally {
            out.close();
        }
    }

    private void keyListFilter(String inWal, String outFile, Function1<OrderedEvent, Object> pred) {
        SiriusLog wal = this.siriusLog(inWal);
        Set keySet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        wal.foreach(new Serializable(pred, keySet){
            public static final long serialVersionUID = 0L;
            private final Function1 pred$2;
            private final Set keySet$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(OrderedEvent x$6) {
                Set set;
                OrderedEvent orderedEvent = x$6;
                if (orderedEvent == null) return BoxedUnit.UNIT;
                OrderedEvent orderedEvent2 = orderedEvent;
                if (!BoxesRunTime.unboxToBoolean((Object)this.pred$2.apply((Object)orderedEvent2))) return BoxedUnit.UNIT;
                System.out.println("Matched");
                NonCommutativeSiriusRequest nonCommutativeSiriusRequest = orderedEvent2.request();
                if (nonCommutativeSiriusRequest instanceof Put) {
                    Put put = (Put)nonCommutativeSiriusRequest;
                    set = (Set)this.keySet$2.$plus$eq((Object)WrappedArray$.MODULE$.make((Object)put.key().getBytes()));
                    return set;
                } else {
                    if (!(nonCommutativeSiriusRequest instanceof Delete)) throw new MatchError((Object)nonCommutativeSiriusRequest);
                    Delete delete = (Delete)nonCommutativeSiriusRequest;
                    set = (Set)this.keySet$2.$minus$eq((Object)WrappedArray$.MODULE$.make((Object)delete.key().getBytes()));
                }
                return set;
            }
            {
                this.pred$2 = pred$2;
                this.keySet$2 = keySet$2;
            }
        });
        PrintWriter out = new PrintWriter(outFile, "UTF-8");
        try {
            keySet.foreach((Function1)new Serializable(out){
                public static final long serialVersionUID = 0L;
                private final PrintWriter out$2;

                public final void apply(WrappedArray<Object> key) {
                    this.out$2.println(new String((byte[])key.toArray(ClassTag$.MODULE$.Byte())));
                }
                {
                    this.out$2 = out$2;
                }
            });
            return;
        }
        finally {
            out.close();
        }
    }

    private void filter(String inUberDir, String outUberDir, Function1<OrderedEvent, Object> pred) {
        block4: {
            SiriusLog siriusLog;
            SiriusLog inWal;
            block3: {
                String string;
                String string2;
                block2: {
                    String string3;
                    this.createFreshDir(outUberDir);
                    inWal = this.siriusLog(inUberDir);
                    string2 = inUberDir;
                    if (string2 == null || !UberTool$.MODULE$.isLegacy(string3 = string2)) break block2;
                    siriusLog = UberStore$.MODULE$.apply(outUberDir);
                    break block3;
                }
                if (string2 == null || !UberTool$.MODULE$.isSegmented(string = string2)) break block4;
                SegmentedUberStore$.MODULE$.init(outUberDir);
                siriusLog = SegmentedUberStore$.MODULE$.apply(outUberDir, SegmentedUberStore$.MODULE$.apply$default$2());
            }
            UberStore outWal = siriusLog;
            this.filter(inWal, outWal, pred);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)inUberDir).append((Object)" does not appear to be a valid Uberstore").toString());
    }

    private void filter(SiriusLog inWal, SiriusLog outWal, Function1<OrderedEvent, Object> pred) {
        inWal.foreach(new Serializable(outWal, pred){
            public static final long serialVersionUID = 0L;
            private final SiriusLog outWal$1;
            private final Function1 pred$1;

            public final void apply(OrderedEvent x0$1) {
                OrderedEvent orderedEvent = x0$1;
                if (BoxesRunTime.unboxToBoolean((Object)this.pred$1.apply((Object)orderedEvent))) {
                    this.outWal$1.writeEntry(orderedEvent);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.outWal$1 = outWal$1;
                this.pred$1 = pred$1;
            }
        });
    }

    private void convertToSegmented(String inLoc, String outLoc, long segmentSize) {
        SiriusConfiguration config = new SiriusConfiguration();
        config.setProp("sirius.uberstore.max-events-per-segment", BoxesRunTime.boxToLong((long)segmentSize));
        UberStore in = UberStore$.MODULE$.apply(inLoc);
        SegmentedUberStore$.MODULE$.init(outLoc);
        SegmentedUberStore out = SegmentedUberStore$.MODULE$.apply(outLoc, config);
        in.foreach(new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final SegmentedUberStore out$3;

            public final void apply(OrderedEvent event) {
                this.out$3.writeEntry(event);
            }
            {
                this.out$3 = out$3;
            }
        });
    }

    private void convertToLegacy(String inLoc, String outLoc) {
        SegmentedUberStore in = SegmentedUberStore$.MODULE$.apply(inLoc, SegmentedUberStore$.MODULE$.apply$default$2());
        UberStore out = UberStore$.MODULE$.apply(outLoc);
        in.foreach(new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final UberStore out$4;

            public final void apply(OrderedEvent event) {
                this.out$4.writeEntry(event);
            }
            {
                this.out$4 = out$4;
            }
        });
    }

    private void initSegmented(String walLoc) {
        SegmentedUberStore$.MODULE$.init(walLoc);
    }

    private void replay(String inWalDir, String host, int concurrency) {
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"Initializing with ").append((Object)BoxesRunTime.boxToInteger((int)concurrency)).append((Object)" Actors").toString());
        String confString = new StringBuilder().append((Object)"\n                akka.actor.default-dispatcher{\n                  type = \"PinnedDispatcher\"\n                  executor= \"thread-pool-executor\"\n                  thread-pool-executor{\n                    max-pool-size-max =").append((Object)BoxesRunTime.boxToInteger((int)concurrency)).append((Object)"\n                  }\n                }\n                ").toString();
        Config customConf = ConfigFactory.parseString((String)confString);
        ActorSystem system = ActorSystem$.MODULE$.apply("Log-Replay", ConfigFactory.load((Config)customConf));
        Timeout timeout = Timeout$.MODULE$.apply(10000L * (long)concurrency);
        SiriusLog inWal = this.siriusLog(inWalDir);
        int reapPeriod = concurrency * 10;
        LongRef start = new LongRef(System.currentTimeMillis());
        ActorRef httpActor = system.actorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(WalTool.HttpDispatchActor.class)).withRouter((RouterConfig)new RoundRobinRouter(concurrency, RoundRobinRouter$.MODULE$.apply$default$2(), RoundRobinRouter$.MODULE$.apply$default$3(), RoundRobinRouter$.MODULE$.apply$default$4(), RoundRobinRouter$.MODULE$.apply$default$5())));
        WalTool.WalAccumulator walAccumulator = inWal.foldLeft(new WalTool.WalAccumulator(0, (List<Future<WalTool.Result>>)Nil$.MODULE$), new Serializable(host, timeout, reapPeriod, start, httpActor){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final Timeout timeout$1;
            private final int reapPeriod$1;
            private final LongRef start$1;
            private final ActorRef httpActor$1;

            public final WalTool.WalAccumulator apply(WalTool.WalAccumulator x0$2, OrderedEvent x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$1);
                if (tuple2 != null) {
                    WalTool.WalAccumulator acc = (WalTool.WalAccumulator)tuple2._1();
                    OrderedEvent evt = (OrderedEvent)tuple2._2();
                    if (acc != null) {
                        WalTool.WalAccumulator walAccumulator;
                        WalTool.WalAccumulator walAccumulator2 = acc;
                        if (walAccumulator2.totalEvents() % this.reapPeriod$1 == 0) {
                            IntRef sumDurations = new IntRef(0);
                            Map cntByStatusCodeMap = ((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
                            Future futureList = Future$.MODULE$.sequence(walAccumulator2.futures(), List$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                            ((List)Await$.MODULE$.result((Awaitable)futureList, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1000)).seconds())).foreach((Function1)new Serializable(this, sumDurations, cntByStatusCodeMap){
                                public static final long serialVersionUID = 0L;
                                private final IntRef sumDurations$1;
                                private final Map cntByStatusCodeMap$1;

                                public final void apply(WalTool.Result result) {
                                    WalTool.Result result2 = result;
                                    if (result2 != null) {
                                        WalTool.Result result3 = result2;
                                        this.cntByStatusCodeMap$1.update((Object)BoxesRunTime.boxToInteger((int)result3.statusCode()), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.cntByStatusCodeMap$1.apply((Object)BoxesRunTime.boxToInteger((int)result3.statusCode()))) + 1)));
                                        this.sumDurations$1.elem += result3.duration();
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        Console$.MODULE$.err().println("Wat");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                                {
                                    this.sumDurations$1 = sumDurations$1;
                                    this.cntByStatusCodeMap$1 = cntByStatusCodeMap$1;
                                }
                            });
                            double elapsedTime = (double)(System.currentTimeMillis() - this.start$1.elem) / (double)1000;
                            this.start$1.elem = System.currentTimeMillis();
                            Console$.MODULE$.err().println("------------------------------------------");
                            Console$.MODULE$.err().println(new StringBuilder().append((Object)"Total Time ").append((Object)BoxesRunTime.boxToDouble((double)elapsedTime)).append((Object)"s").toString());
                            double rps = (double)this.reapPeriod$1 / elapsedTime;
                            this.printResultsByErrorCode$1(cntByStatusCodeMap, Console$.MODULE$.err());
                            int avgDuration = sumDurations.elem / this.reapPeriod$1;
                            double errorRate = (double)(this.reapPeriod$1 - BoxesRunTime.unboxToInt((Object)cntByStatusCodeMap.apply((Object)BoxesRunTime.boxToInteger((int)200)))) / (double)this.reapPeriod$1 * (double)100;
                            Console$.MODULE$.err().println(new StringBuilder().append((Object)"Avg Duration ").append((Object)BoxesRunTime.boxToInteger((int)avgDuration)).append((Object)" ms for last ").append((Object)BoxesRunTime.boxToInteger((int)this.reapPeriod$1)).append((Object)" requests").toString());
                            Console$.MODULE$.err().println(new StringBuilder().append((Object)"Error Rate ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)errorRate)}))).append((Object)"%").toString());
                            Console$.MODULE$.err().println(new StringBuilder().append((Object)"RPS ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rps)}))).toString());
                            Console$.MODULE$.err().println("------------------------------------------");
                            Console$.MODULE$.err().println();
                            Console$.MODULE$.err().println();
                            Future future = akka.pattern.package$.MODULE$.ask(this.httpActor$1, (Object)new WalTool.Send(evt, this.host$1), this.timeout$1).mapTo(ClassTag$.MODULE$.apply(WalTool.Result.class));
                            WalTool.WalAccumulator walAccumulator3 = new WalTool.WalAccumulator(walAccumulator2.totalEvents() + 1, (List<Future<WalTool.Result>>)Nil$.MODULE$.$colon$colon((Object)future));
                            walAccumulator = walAccumulator3;
                        } else {
                            Future future = akka.pattern.package$.MODULE$.ask(this.httpActor$1, (Object)new WalTool.Send(evt, this.host$1), this.timeout$1).mapTo(ClassTag$.MODULE$.apply(WalTool.Result.class));
                            WalTool.WalAccumulator walAccumulator4 = new WalTool.WalAccumulator(walAccumulator2.totalEvents() + 1, (List<Future<WalTool.Result>>)walAccumulator2.futures().$colon$colon((Object)future));
                            walAccumulator = walAccumulator4;
                        }
                        WalTool.WalAccumulator walAccumulator5 = walAccumulator;
                        return walAccumulator5;
                    }
                }
                throw new MatchError((Object)tuple2);
            }

            private final void printResultsByErrorCode$1(Map cntByStatusCodeMap, OutputStream out) {
                Console$.MODULE$.err().println();
                if (cntByStatusCodeMap.isEmpty()) {
                    Console$.MODULE$.err().println("No Results");
                } else {
                    Console$.MODULE$.err().println("Response Counts by Code");
                    cntByStatusCodeMap.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> p) {
                            int n = p._1$mcI$sp();
                            switch (n) {
                                default: {
                                    Console$.MODULE$.err().println(new StringBuilder().append((Object)"     Code: ").append((Object)BoxesRunTime.boxToInteger((int)p._1$mcI$sp())).append((Object)" = ").append((Object)BoxesRunTime.boxToInteger((int)p._2$mcI$sp())).toString());
                                    break;
                                }
                                case 0: {
                                    Console$.MODULE$.err().println(new StringBuilder().append((Object)"     Code: Err = ").append((Object)BoxesRunTime.boxToInteger((int)p._2$mcI$sp())).toString());
                                }
                            }
                        }
                    });
                    Console$.MODULE$.err().println();
                }
                Console$.MODULE$.err().println();
            }
            {
                this.host$1 = host$1;
                this.timeout$1 = timeout$1;
                this.reapPeriod$1 = reapPeriod$1;
                this.start$1 = start$1;
                this.httpActor$1 = httpActor$1;
            }
        });
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"Processed ").append((Object)BoxesRunTime.boxToInteger((int)walAccumulator.totalEvents())).append((Object)" OrderedEvents").toString());
        Future futureList = Future$.MODULE$.sequence(walAccumulator.futures(), List$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)futureList, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).seconds());
    }

    private SiriusLog siriusLog(String inDirName) {
        block4: {
            SiriusLog siriusLog;
            block3: {
                String string;
                String string2;
                block2: {
                    String string3;
                    string2 = inDirName;
                    if (string2 == null || !UberTool$.MODULE$.isLegacy(string3 = string2)) break block2;
                    siriusLog = UberStore$.MODULE$.apply(string3);
                    break block3;
                }
                if (string2 == null || !UberTool$.MODULE$.isSegmented(string = string2)) break block4;
                siriusLog = SegmentedUberStore$.MODULE$.apply(string, SegmentedUberStore$.MODULE$.apply$default$2());
            }
            return siriusLog;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)inDirName).append((Object)" does not appear to be a valid Uberstore").toString());
    }

    private WalTool$() {
        MODULE$ = this;
    }
}

