/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.xfinity.sirius.uberstore.data;

import com.comcast.xfinity.sirius.api.impl.Delete;
import com.comcast.xfinity.sirius.api.impl.NonCommutativeSiriusRequest;
import com.comcast.xfinity.sirius.api.impl.OrderedEvent;
import com.comcast.xfinity.sirius.api.impl.Put;
import com.comcast.xfinity.sirius.uberstore.data.OrderedEventCodec;
import java.nio.ByteBuffer;
import scala.MatchError;
import scala.Product;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001f\t\u0001\")\u001b8bef,e/\u001a8u\u0007>$Wm\u0019\u0006\u0003\u0007\u0011\tA\u0001Z1uC*\u0011QAB\u0001\nk\n,'o\u001d;pe\u0016T!a\u0002\u0005\u0002\rML'/[;t\u0015\tI!\"A\u0004yM&t\u0017\u000e^=\u000b\u0005-a\u0011aB2p[\u000e\f7\u000f\u001e\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0003\u0013\tI\"AA\tPe\u0012,'/\u001a3Fm\u0016tGoQ8eK\u000eDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005]\u0001\u0001bB\u0010\u0001\u0005\u0004%i\u0001I\u0001\t!V#vlQ(E\u000bV\t\u0011\u0005\u0005\u0002\u0012E%\u00111E\u0005\u0002\u0004\u0013:$\bBB\u0013\u0001A\u00035\u0011%A\u0005Q+R{6i\u0014#FA!9q\u0005\u0001b\u0001\n\u001b\u0001\u0013a\u0003#F\u0019\u0016#ViX\"P\t\u0016Ca!\u000b\u0001!\u0002\u001b\t\u0013\u0001\u0004#F\u0019\u0016#ViX\"P\t\u0016\u0003\u0003bB\u0016\u0001\u0005\u0004%i\u0001L\u0001\f\u000b6\u0003F+W0C3R+5+F\u0001.!\r\tb\u0006M\u0005\u0003_I\u0011Q!\u0011:sCf\u0004\"!E\u0019\n\u0005I\u0012\"\u0001\u0002\"zi\u0016Da\u0001\u000e\u0001!\u0002\u001bi\u0013\u0001D#N!RKvLQ-U\u000bN\u0003\u0003\"\u0002\u001c\u0001\t\u00039\u0014!C:fe&\fG.\u001b>f)\ti\u0003\bC\u0003:k\u0001\u0007!(A\u0003fm\u0016tG\u000f\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!\u0011.\u001c9m\u0015\tyd!A\u0002ba&L!!\u0011\u001f\u0003\u0019=\u0013H-\u001a:fI\u00163XM\u001c;\t\u000b\r\u0003A\u0011\u0001#\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0003u\u0015CQA\u0012\"A\u00025\nQAY=uKNDQ\u0001\u0013\u0001\u0005\n%\u000b\u0001\u0004^=qK\u000e{G-\u001a$s_6|%\u000fZ3sK\u0012,e/\u001a8u)\t\t#\nC\u0003:\u000f\u0002\u0007!\bC\u0003M\u0001\u0011%Q*A\nlKf4%o\\7Pe\u0012,'/\u001a3Fm\u0016tG\u000f\u0006\u0002O+B\u0011qJ\u0015\b\u0003#AK!!\u0015\n\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#JAQ!O&A\u0002iBQa\u0016\u0001\u0005\na\u000bACY8es\u001a\u0013x.\\(sI\u0016\u0014X\rZ#wK:$HCA\u0017Z\u0011\u0015Id\u000b1\u0001;\u0001")
public class BinaryEventCodec
implements OrderedEventCodec {
    private final int PUT_CODE;
    private final int DELETE_CODE;
    private final byte[] EMPTY_BYTES = new byte[0];

    private final int PUT_CODE() {
        return this.PUT_CODE;
    }

    private final int DELETE_CODE() {
        return this.DELETE_CODE;
    }

    private final byte[] EMPTY_BYTES() {
        return this.EMPTY_BYTES;
    }

    @Override
    public byte[] serialize(OrderedEvent event) {
        int typeCode = this.typeCodeFromOrderedEvent(event);
        byte[] key = this.keyFromOrderedEvent(event).getBytes();
        byte[] body = this.bodyFromOrderedEvent(event);
        int keyLen = key.length;
        int bodyLen = body.length;
        ByteBuffer eventBuf = ByteBuffer.allocate(28 + keyLen + bodyLen);
        return eventBuf.putLong(event.sequence()).putLong(event.timestamp()).putInt(typeCode).putInt(keyLen).putInt(bodyLen).put(key).put(body).array();
    }

    @Override
    public OrderedEvent deserialize(byte[] bytes) {
        ByteBuffer eventBuf = ByteBuffer.wrap(bytes);
        long seq = eventBuf.getLong();
        long timestamp = eventBuf.getLong();
        int typeCode = eventBuf.getInt();
        int keyLen = eventBuf.getInt();
        int bodyLen = eventBuf.getInt();
        byte[] keyBytes = new byte[keyLen];
        eventBuf.get(keyBytes);
        String key = new String(keyBytes);
        byte[] body = new byte[bodyLen];
        eventBuf.get(body);
        Product req = typeCode == this.PUT_CODE() ? new Put(key, body) : new Delete(key);
        return new OrderedEvent(seq, timestamp, (NonCommutativeSiriusRequest)req);
    }

    private int typeCodeFromOrderedEvent(OrderedEvent event) {
        NonCommutativeSiriusRequest nonCommutativeSiriusRequest;
        block4: {
            int n;
            block3: {
                block2: {
                    nonCommutativeSiriusRequest = event.request();
                    if (!(nonCommutativeSiriusRequest instanceof Put)) break block2;
                    n = this.PUT_CODE();
                    break block3;
                }
                if (!(nonCommutativeSiriusRequest instanceof Delete)) break block4;
                n = this.DELETE_CODE();
            }
            return n;
        }
        throw new MatchError((Object)nonCommutativeSiriusRequest);
    }

    private String keyFromOrderedEvent(OrderedEvent event) {
        NonCommutativeSiriusRequest nonCommutativeSiriusRequest;
        block4: {
            String string;
            block3: {
                String key;
                block2: {
                    String key2;
                    nonCommutativeSiriusRequest = event.request();
                    if (!(nonCommutativeSiriusRequest instanceof Put)) break block2;
                    Put put = (Put)nonCommutativeSiriusRequest;
                    string = key2 = put.key();
                    break block3;
                }
                if (!(nonCommutativeSiriusRequest instanceof Delete)) break block4;
                Delete delete = (Delete)nonCommutativeSiriusRequest;
                string = key = delete.key();
            }
            return string;
        }
        throw new MatchError((Object)nonCommutativeSiriusRequest);
    }

    private byte[] bodyFromOrderedEvent(OrderedEvent event) {
        NonCommutativeSiriusRequest nonCommutativeSiriusRequest;
        block4: {
            byte[] byArray;
            block3: {
                block2: {
                    nonCommutativeSiriusRequest = event.request();
                    if (!(nonCommutativeSiriusRequest instanceof Put)) break block2;
                    Put put = (Put)nonCommutativeSiriusRequest;
                    byte[] body = put.body();
                    byArray = body;
                    break block3;
                }
                if (!(nonCommutativeSiriusRequest instanceof Delete)) break block4;
                byArray = this.EMPTY_BYTES();
            }
            return byArray;
        }
        throw new MatchError((Object)nonCommutativeSiriusRequest);
    }

    public BinaryEventCodec() {
        this.PUT_CODE = 1;
        this.DELETE_CODE = 2;
    }
}

