/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.xfinity.sirius.uberstore.segmented;

import com.comcast.xfinity.sirius.api.impl.OrderedEvent;
import com.comcast.xfinity.sirius.uberstore.segmented.Segment;
import com.comcast.xfinity.sirius.uberstore.segmented.Segment$;
import java.io.File;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalax.file.Path;
import scalax.file.Path$;
import scalax.file.defaultfs.DefaultPath;

public final class SegmentedCompactor$ {
    public static final SegmentedCompactor$ MODULE$;
    private final String COMPACTING_SUFFIX;
    private final String TEMP_SUFFIX;

    static {
        new SegmentedCompactor$();
    }

    public String COMPACTING_SUFFIX() {
        return this.COMPACTING_SUFFIX;
    }

    public String TEMP_SUFFIX() {
        return this.TEMP_SUFFIX;
    }

    public Segment replace(Segment original, String replacement) {
        original.close();
        DefaultPath originalPath = Path$.MODULE$.fromString(original.location().getAbsolutePath());
        DefaultPath replacementPath = Path$.MODULE$.fromString(replacement);
        DefaultPath tempPath = Path$.MODULE$.fromString(new File(original.location().getParent(), new StringBuilder().append((Object)original.location().getName()).append((Object)this.TEMP_SUFFIX()).toString()).getAbsolutePath());
        originalPath.moveTo((Path)tempPath, originalPath.moveTo$default$2(), originalPath.moveTo$default$3());
        replacementPath.moveTo((Path)originalPath, replacementPath.moveTo$default$2(), replacementPath.moveTo$default$3());
        tempPath.deleteRecursively(tempPath.deleteRecursively$default$1(), tempPath.deleteRecursively$default$2());
        return Segment$.MODULE$.apply(original.location().getParentFile(), original.location().getName());
    }

    public List<Segment> findCompactableSegments(List<Segment> segments) {
        return (List)segments.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Segment x$1) {
                return x$1.isApplied();
            }
        });
    }

    public Map<Segment, String> compactAgainst(Segment toCompact, List<Segment> allSegments) {
        return this.compactSegments(toCompact, (List<Segment>)((List)allSegments.filter((Function1)new Serializable(toCompact){
            public static final long serialVersionUID = 0L;
            private final Segment toCompact$1;

            public final boolean apply(Segment x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2.name())).toLong() < new StringOps(Predef$.MODULE$.augmentString(this.toCompact$1.name())).toLong();
            }
            {
                this.toCompact$1 = toCompact$1;
            }
        })));
    }

    private Map<Segment, String> compactSegments(Segment toCompact, List<Segment> segments) {
        Set<String> keys2 = toCompact.keys();
        return (Map)segments.foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(keys2){
            public static final long serialVersionUID = 0L;
            private final Set keys$1;

            public final Map<Segment, String> apply(Map<Segment, String> map, Segment toCompact) {
                Segment compactInto = Segment$.MODULE$.apply(toCompact.location().getParentFile(), new StringBuilder().append((Object)toCompact.name()).append((Object)SegmentedCompactor$.MODULE$.COMPACTING_SUFFIX()).toString());
                SegmentedCompactor$.MODULE$.com$comcast$xfinity$sirius$uberstore$segmented$SegmentedCompactor$$compactSegment((Set<String>)this.keys$1, toCompact, compactInto);
                compactInto.setApplied(toCompact.isApplied());
                compactInto.close();
                return map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)toCompact), (Object)compactInto.location().getAbsolutePath()));
            }
            {
                this.keys$1 = keys$1;
            }
        });
    }

    public void com$comcast$xfinity$sirius$uberstore$segmented$SegmentedCompactor$$compactSegment(Set<String> keys2, Segment source, Segment dest) {
        source.foreach(new Serializable(keys2, dest){
            public static final long serialVersionUID = 0L;
            private final Set keys$2;
            private final Segment dest$1;

            public final void apply(OrderedEvent x0$1) {
                OrderedEvent orderedEvent = x0$1;
                if (this.keys$2.contains((Object)orderedEvent.request().key())) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.dest$1.writeEntry(orderedEvent);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.keys$2 = keys$2;
                this.dest$1 = dest$1;
            }
        });
    }

    public Option<Tuple2<Segment, Segment>> findNextMergeableSegments(List<Segment> segments, Function2<Segment, Segment, Object> isMergeable) {
        while (true) {
            block5: {
                None$ none$;
                block4: {
                    List list;
                    block3: {
                        if ((list = segments.take(2)).size() >= 2) break block3;
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    if (!BoxesRunTime.unboxToBoolean((Object)isMergeable.apply(list.apply(0), list.apply(1)))) break block5;
                    none$ = new Some((Object)new Tuple2(list.apply(0), list.apply(1)));
                }
                return none$;
            }
            segments = (List)segments.tail();
        }
    }

    public void delete(Segment segment) {
        segment.close();
        DefaultPath qual$1 = Path$.MODULE$.fromString(segment.location().getAbsolutePath());
        boolean x$3 = qual$1.deleteRecursively$default$1();
        boolean x$4 = qual$1.deleteRecursively$default$2();
        qual$1.deleteRecursively(x$3, x$4);
    }

    public void mergeSegments(Segment left, Segment right, File targetFile) {
        Segment target = Segment$.MODULE$.apply(targetFile);
        left.foreach(new Serializable(target){
            public static final long serialVersionUID = 0L;
            private final Segment target$1;

            public final void apply(OrderedEvent event) {
                this.target$1.writeEntry(event);
            }
            {
                this.target$1 = target$1;
            }
        });
        right.foreach(new Serializable(target){
            public static final long serialVersionUID = 0L;
            private final Segment target$1;

            public final void apply(OrderedEvent event) {
                this.target$1.writeEntry(event);
            }
            {
                this.target$1 = target$1;
            }
        });
        target.setApplied(left.isApplied() && right.isApplied());
        target.close();
    }

    private SegmentedCompactor$() {
        MODULE$ = this;
        this.COMPACTING_SUFFIX = ".compacting";
        this.TEMP_SUFFIX = ".temp";
    }
}

