/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.xfinity.sirius.uberstore.segmented;

import com.comcast.xfinity.sirius.api.SiriusConfiguration;
import com.comcast.xfinity.sirius.uberstore.segmented.SegmentedCompactor$;
import com.comcast.xfinity.sirius.uberstore.segmented.SegmentedUberStore;
import java.io.File;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalax.file.Path;
import scalax.file.Path$;
import scalax.file.defaultfs.DefaultPath;

public final class SegmentedUberStore$ {
    public static final SegmentedUberStore$ MODULE$;

    static {
        new SegmentedUberStore$();
    }

    public String versionId() {
        return "SEGMENTED-1.0";
    }

    public void init(String location) {
        File dir = new File(location);
        dir.mkdirs();
        new File(dir, this.versionId()).createNewFile();
    }

    public void repair(String location) {
        File dir = new File(location);
        Set baseNames = (Set)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.getName().contains(".");
            }
        })).foldLeft((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<String> apply(Set<String> acc, File file) {
                return (Set)acc.$plus((Object)file.getName().substring(0, file.getName().indexOf(46)));
            }
        });
        baseNames.foreach((Function1)new Serializable(dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final Object apply(String baseName) {
                BoxedUnit boxedUnit;
                File baseFile = new File(this.dir$1, baseName);
                File tempFile = new File(this.dir$1, new StringBuilder().append((Object)baseName).append((Object)SegmentedCompactor$.MODULE$.TEMP_SUFFIX()).toString());
                File compactedFile = new File(this.dir$1, new StringBuilder().append((Object)baseName).append((Object)SegmentedCompactor$.MODULE$.COMPACTING_SUFFIX()).toString());
                if (baseFile.exists() && compactedFile.exists()) {
                    DefaultPath qual$1 = Path$.MODULE$.apply(compactedFile);
                    boolean x$14 = qual$1.deleteRecursively$default$1();
                    boolean x$15 = qual$1.deleteRecursively$default$2();
                    boxedUnit = qual$1.deleteRecursively(x$14, x$15);
                } else if (tempFile.exists() && compactedFile.exists()) {
                    DefaultPath qual$2 = Path$.MODULE$.apply(compactedFile);
                    DefaultPath x$16 = Path$.MODULE$.apply(baseFile);
                    boolean x$17 = qual$2.moveTo$default$2();
                    boolean x$18 = qual$2.moveTo$default$3();
                    qual$2.moveTo((Path)x$16, x$17, x$18);
                    DefaultPath qual$3 = Path$.MODULE$.apply(tempFile);
                    boolean x$19 = qual$3.deleteRecursively$default$1();
                    boolean x$20 = qual$3.deleteRecursively$default$2();
                    boxedUnit = qual$3.deleteRecursively(x$19, x$20);
                } else if (baseFile.exists() && tempFile.exists()) {
                    DefaultPath qual$4 = Path$.MODULE$.apply(tempFile);
                    boolean x$21 = qual$4.deleteRecursively$default$1();
                    boolean x$22 = qual$4.deleteRecursively$default$2();
                    boxedUnit = qual$4.deleteRecursively(x$21, x$22);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.dir$1 = dir$1;
            }
        });
    }

    public SegmentedUberStore apply(String base, SiriusConfiguration siriusConfig) {
        long MAX_EVENTS_PER_SEGMENT = BoxesRunTime.unboxToLong(siriusConfig.getProp("sirius.uberstore.max-events-per-segment", new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 1000000L;
            }
        }));
        if (new File(base, this.versionId()).exists()) {
            this.repair(base);
            return new SegmentedUberStore(new File(base), MAX_EVENTS_PER_SEGMENT);
        }
        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot start. Configured to boot with storage: %s, which is not found in %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.versionId(), base})));
    }

    public SiriusConfiguration apply$default$2() {
        return new SiriusConfiguration();
    }

    private SegmentedUberStore$() {
        MODULE$ = this;
    }
}

