/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.codegen.di;

import io.vrap.rmf.codegen.UtilsKt;
import io.vrap.rmf.codegen.di.ApiProvider;
import io.vrap.rmf.codegen.di.RamlApiProvider;
import io.vrap.rmf.raml.model.RamlDiagnostic;
import io.vrap.rmf.raml.model.RamlModelBuilder;
import io.vrap.rmf.raml.model.RamlModelResult;
import io.vrap.rmf.raml.model.modules.Api;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.eclipse.emf.common.util.URI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/vrap/rmf/codegen/di/RamlApiProvider;", "Lio/vrap/rmf/codegen/di/ApiProvider;", "ramlFileLocation", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "api", "Lio/vrap/rmf/raml/model/modules/Api;", "getApi", "()Lio/vrap/rmf/raml/model/modules/Api;", "api$delegate", "Lkotlin/Lazy;", "gitHash", "", "getGitHash", "()Ljava/lang/String;", "gitHash$delegate", "logger", "Lorg/slf4j/Logger;", "codegen-core"})
public final class RamlApiProvider
implements ApiProvider {
    @NotNull
    private final Path ramlFileLocation;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy gitHash$delegate;
    @NotNull
    private final Lazy api$delegate;

    public RamlApiProvider(@NotNull Path ramlFileLocation) {
        Intrinsics.checkNotNullParameter((Object)ramlFileLocation, (String)"ramlFileLocation");
        this.ramlFileLocation = ramlFileLocation;
        Logger logger = LoggerFactory.getLogger(RamlApiProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(RamlApiProvider::class.java)");
        this.logger = logger;
        this.gitHash$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ RamlApiProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object;
                try {
                    InputStream inputStream = Runtime.getRuntime().exec("git -C " + RamlApiProvider.access$getRamlFileLocation$p(this.this$0).getParent() + " rev-parse HEAD").getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getRuntime().exec(\"git -\u2026-parse HEAD\").inputStream");
                    object = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader((InputStream)object, charset);
                    int n = 8192;
                    String string = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
                    if (string == null) {
                        string = "";
                    }
                    object = string;
                }
                catch (IOException e) {
                    RamlApiProvider.access$getLogger$p(this.this$0).info("Couldn't retrieve git hash for {}", (Object)RamlApiProvider.access$getRamlFileLocation$p(this.this$0).getParent(), (Object)e);
                    object = "";
                }
                return object;
            }
        }));
        this.api$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Api>(this){
            final /* synthetic */ RamlApiProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Api invoke() {
                URI fileURI = URI.createURI((String)RamlApiProvider.access$getRamlFileLocation$p(this.this$0).toUri().toString());
                boolean $i$f$executeAndMeasureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                RamlModelResult result$iv = new RamlModelBuilder().buildApi(fileURI);
                Pair pair = TuplesKt.to((Object)result$iv, (Object)(System.currentTimeMillis() - start$iv));
                RamlModelResult modelResult = (RamlModelResult)pair.component1();
                long duration = ((Number)pair.component2()).longValue();
                RamlApiProvider.access$getLogger$p(this.this$0).info("Parsing API took " + UtilsKt.toSeconds(duration, 3) + 's');
                List validationResults = modelResult.getValidationResults();
                if (!validationResults.isEmpty()) {
                    RamlApiProvider.access$getLogger$p(this.this$0).warn("Error(s) found validating " + fileURI.toFileString() + ':');
                    validationResults.stream().forEach(arg_0 -> api.2.invoke$lambda$1((Function1)new Function1<RamlDiagnostic, Unit>(this.this$0){
                        final /* synthetic */ RamlApiProvider this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(RamlDiagnostic it) {
                            RamlApiProvider.access$getLogger$p(this.this$0).warn(it.toString());
                        }
                    }, arg_0));
                    throw new RuntimeException("Error while parsing file " + fileURI.toFileString());
                }
                return (Api)modelResult.getRootObject();
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }));
    }

    @Override
    @NotNull
    public String getGitHash() {
        Lazy lazy = this.gitHash$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Api getApi() {
        Lazy lazy = this.api$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-api>(...)");
        return (Api)object;
    }

    public static final /* synthetic */ Path access$getRamlFileLocation$p(RamlApiProvider $this) {
        return $this.ramlFileLocation;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RamlApiProvider $this) {
        return $this.logger;
    }
}

