/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.codegen.io;

import io.vrap.rmf.codegen.io.DataSink;
import io.vrap.rmf.codegen.io.TemplateFile;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/vrap/rmf/codegen/io/FileDataSink;", "Lio/vrap/rmf/codegen/io/DataSink;", "outputFolder", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "generatedFiles", "", "Ljava/io/File;", "getOutputFolder", "()Ljava/nio/file/Path;", "checksum", "", "input", "Ljava/io/InputStream;", "postClean", "", "write", "templateFile", "Lio/vrap/rmf/codegen/io/TemplateFile;", "codegen-core"})
public final class FileDataSink
implements DataSink {
    @NotNull
    private final Path outputFolder;
    @NotNull
    private final List<File> generatedFiles;

    public FileDataSink(@NotNull Path outputFolder) {
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        this.outputFolder = outputFolder;
        this.generatedFiles = new ArrayList();
    }

    @NotNull
    public final Path getOutputFolder() {
        return this.outputFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull TemplateFile templateFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)templateFile, (String)"templateFile");
        File outputFile = new File(this.outputFolder + '/' + templateFile.getRelativePath());
        String content = ((Object)StringsKt.trimEnd((CharSequence)templateFile.getContent())).toString() + '\n';
        if (outputFile.exists()) {
            byte[] fileHash = this.checksum(new FileInputStream(outputFile));
            String string = content;
            object = Charsets.UTF_8;
            byte[] byArray = string.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] templateHash = this.checksum(new ByteArrayInputStream(byArray));
            if (fileHash != null && templateHash != null && Arrays.equals(fileHash, templateHash)) {
                this.generatedFiles.add(outputFile);
                return;
            }
        }
        outputFile.getParentFile().mkdirs();
        outputFile.createNewFile();
        Object object2 = outputFile;
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        object = object2;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object3);
        object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object3 = null;
        try {
            BufferedWriter it = (BufferedWriter)object2;
            boolean bl = false;
            it.write(content);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        this.generatedFiles.add(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] checksum(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            Closeable closeable = input;
            Throwable throwable = null;
            try {
                InputStream in = (InputStream)closeable;
                boolean bl = false;
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                byte[] block = new byte[4096];
                int length = 0;
                while (true) {
                    int n;
                    int it = n = in.read(block);
                    boolean bl2 = false;
                    length = it;
                    if (n <= 0) break;
                    digest.update(block, 0, length);
                }
                byte[] byArray = digest.digest();
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postClean() {
        void $this$mapTo$iv$iv;
        File it;
        Iterable $this$filterNotTo$iv$iv;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.outputFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Collection collection = FileUtils.listFiles((File)this.outputFolder.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"listFiles(\n             \u2026Filter.INSTANCE\n        )");
        Iterable $this$filterNot$iv = collection;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (this.generatedFiles.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = (List)destination$iv$iv;
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.delete());
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Override
    public boolean clean() {
        return DataSink.DefaultImpls.clean(this);
    }
}

