/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.http.apachehttp;

import com.commercetools.http.apachehttp.BuilderOptions;
import com.commercetools.http.apachehttp.CompletableFutureCallbackAdapter;
import com.commercetools.http.apachehttp.HttpException;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.HttpClientBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.ssl.TlsDetails;

public class CtApacheHttpClient
extends HttpClientBase {
    public static final int MAX_REQUESTS = 64;
    private final CloseableHttpAsyncClient apacheHttpClient;
    private final Supplier<HttpAsyncClientBuilder> clientBuilder = CtApacheHttpClient::createClientBuilder;

    public static HttpAsyncClientBuilder createClientBuilder() {
        return CtApacheHttpClient.createClientBuilder((AsyncClientConnectionManager)CtApacheHttpClient.createConnectionManager(64, 64).build());
    }

    public static HttpAsyncClientBuilder createClientBuilder(AsyncClientConnectionManager cm) {
        return HttpAsyncClientBuilder.create().setVersionPolicy(HttpVersionPolicy.NEGOTIATE).setConnectionManager(cm);
    }

    public static PoolingAsyncClientConnectionManagerBuilder createConnectionManager(int maxConnTotal, int maxConnPerRoute) {
        TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().useSystemProperties().setTlsDetailsFactory(sslEngine -> new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol())).build();
        return PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnPerRoute(maxConnPerRoute).setMaxConnTotal(maxConnTotal).setTlsStrategy(tlsStrategy);
    }

    private void init() {
        if (this.apacheHttpClient.getStatus() != IOReactorStatus.ACTIVE) {
            this.apacheHttpClient.start();
        }
    }

    public CtApacheHttpClient() {
        this.apacheHttpClient = this.clientBuilder.get().build();
        this.init();
    }

    public CtApacheHttpClient(int maxConnTotal, int maxConnPerRoute) {
        this.apacheHttpClient = CtApacheHttpClient.createClientBuilder((AsyncClientConnectionManager)CtApacheHttpClient.createConnectionManager(maxConnTotal, maxConnPerRoute).build()).build();
        this.init();
    }

    public CtApacheHttpClient(BuilderOptions options) {
        this.apacheHttpClient = options.plus(this.clientBuilder.get()).build();
        this.init();
    }

    public CtApacheHttpClient(int maxConnTotal, int maxConnPerRoute, BuilderOptions options) {
        this.apacheHttpClient = options.plus(CtApacheHttpClient.createClientBuilder((AsyncClientConnectionManager)CtApacheHttpClient.createConnectionManager(maxConnTotal, maxConnPerRoute).build())).build();
        this.init();
    }

    public CtApacheHttpClient(Supplier<HttpAsyncClientBuilder> builderSupplier) {
        this.apacheHttpClient = builderSupplier.get().build();
        this.init();
    }

    public CtApacheHttpClient(ExecutorService executor) {
        super(executor);
        this.apacheHttpClient = this.clientBuilder.get().build();
        this.init();
    }

    public CtApacheHttpClient(ExecutorService executor, int maxConnTotal, int maxConnPerRoute) {
        super(executor);
        this.apacheHttpClient = CtApacheHttpClient.createClientBuilder((AsyncClientConnectionManager)CtApacheHttpClient.createConnectionManager(maxConnTotal, maxConnPerRoute).build()).build();
        this.init();
    }

    public CtApacheHttpClient(ExecutorService executor, BuilderOptions options) {
        super(executor);
        this.apacheHttpClient = options.plus(this.clientBuilder.get()).build();
        this.init();
    }

    public CtApacheHttpClient(ExecutorService executor, int maxConnTotal, int maxConnPerRoute, BuilderOptions options) {
        super(executor);
        this.apacheHttpClient = options.plus(CtApacheHttpClient.createClientBuilder((AsyncClientConnectionManager)CtApacheHttpClient.createConnectionManager(maxConnTotal, maxConnPerRoute).build())).build();
        this.init();
    }

    public CtApacheHttpClient(ExecutorService executor, Supplier<HttpAsyncClientBuilder> builderSupplier) {
        super(executor);
        this.apacheHttpClient = builderSupplier.get().build();
        this.init();
    }

    private AsyncRequestProducer toApacheRequest(ApiHttpRequest httpRequest) {
        String method = httpRequest.getMethod().toString();
        AsyncRequestBuilder builder = AsyncRequestBuilder.create((String)method);
        builder.setUri(httpRequest.getUri());
        httpRequest.getHeaders().getHeaders().forEach(entry -> builder.addHeader((String)entry.getKey(), (String)entry.getValue()));
        if (httpRequest.getBody() != null) {
            ContentType mediaType = ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8);
            if (httpRequest.getHeaders().getHeaders().stream().anyMatch(s -> ((String)s.getKey()).equalsIgnoreCase("Content-Type"))) {
                mediaType = ContentType.parse((CharSequence)Objects.requireNonNull(httpRequest.getHeaders().getFirst("Content-Type")));
            }
            builder.setEntity(httpRequest.getBody(), mediaType);
        }
        return builder.build();
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        CompletableFuture apacheResponseFuture = new CompletableFuture();
        this.apacheHttpClient.execute(this.toApacheRequest(request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), new CompletableFutureCallbackAdapter(apacheResponseFuture));
        return apacheResponseFuture.thenApplyAsync(CtApacheHttpClient::toResponse, this.executor());
    }

    private static ApiHttpResponse<byte[]> toResponse(SimpleHttpResponse response) {
        Map<String, List<Header>> apacheHeaders = Arrays.stream(response.getHeaders()).collect(Collectors.groupingBy(NameValuePair::getName));
        ApiHttpHeaders apiHttpHeaders = new ApiHttpHeaders(apacheHeaders.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(value -> ApiHttpHeaders.headerEntry((String)((String)e.getKey()), (String)value.getValue()))).collect(Collectors.toList()));
        byte[] bodyNullable = Optional.ofNullable(response.getBody()).map(entity -> {
            try {
                boolean gzipEncoded = Optional.ofNullable(response.getFirstHeader("Content-Encoding")).map(NameValuePair::getValue).map(v -> v.equalsIgnoreCase("gzip")).orElse(false);
                ByteArrayInputStream body = new ByteArrayInputStream(entity.getBodyBytes());
                InputStream content = gzipEncoded ? new GZIPInputStream(body) : body;
                AutoCloseInputStream autoCloseInputStream = new AutoCloseInputStream(content);
                return IOUtils.toByteArray((InputStream)autoCloseInputStream);
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
        }).orElse(null);
        return new ApiHttpResponse(response.getCode(), apiHttpHeaders, (Object)bodyNullable, response.getReasonPhrase());
    }

    public void closeDelegate() throws Exception {
        this.apacheHttpClient.close();
    }
}

