/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api;

import com.commercetools.api.client.ErrorableTrait;
import com.commercetools.graphql.api.GraphQLDataResponse;
import com.commercetools.graphql.api.GraphQLRequest;
import com.commercetools.graphql.api.GraphQLResponse;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.BodyApiMethod;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ByProjectKeyGraphqlQuery<T>
extends BodyApiMethod<ByProjectKeyGraphqlQuery<T>, GraphQLResponse<T>, GraphQLRequest<T>>
implements ErrorableTrait<ByProjectKeyGraphqlQuery<T>> {
    private String projectKey;
    private GraphQLRequest<T> graphQLRequest;

    public ByProjectKeyGraphqlQuery(ApiHttpClient apiHttpClient, String projectKey, GraphQLRequest<T> graphQLRequest) {
        super(apiHttpClient);
        this.projectKey = projectKey;
        this.graphQLRequest = graphQLRequest;
    }

    public ByProjectKeyGraphqlQuery(ByProjectKeyGraphqlQuery<T> t) {
        super(t);
        this.projectKey = t.projectKey;
        this.graphQLRequest = t.graphQLRequest;
    }

    protected ApiHttpRequest buildHttpRequest() {
        ArrayList params = new ArrayList(this.getQueryParamUriStrings());
        String httpRequestPath = String.format("%s/graphql", this.projectKey);
        if (!params.isEmpty()) {
            httpRequestPath = httpRequestPath + "?" + String.join((CharSequence)"&", params);
        }
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(httpRequestPath), this.getHeaders(), (byte[])JsonUtils.executing(() -> this.apiHttpClient().getSerializerService().toJsonByteArray(this.graphQLRequest)));
    }

    public ApiHttpResponse<GraphQLResponse<T>> executeBlocking(ApiHttpClient client, Duration timeout) {
        return this.executeBlocking(client, timeout, GraphQLDataResponse.class).withBody(graphQLDataResponse -> GraphQLResponse.of(graphQLDataResponse, this.graphQLRequest));
    }

    public CompletableFuture<ApiHttpResponse<GraphQLResponse<T>>> execute(ApiHttpClient client) {
        return this.execute(client, GraphQLDataResponse.class).thenApply(response -> response.withBody(graphQLDataResponse -> GraphQLResponse.of((GraphQLDataResponse)response.getBody(), this.graphQLRequest)));
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public GraphQLRequest<T> getBody() {
        return this.graphQLRequest;
    }

    public ByProjectKeyGraphqlQuery<T> withBody(GraphQLRequest<T> graphQLRequest) {
        ByProjectKeyGraphqlQuery<T> t = this.copy();
        t.graphQLRequest = graphQLRequest;
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ByProjectKeyGraphqlQuery that = (ByProjectKeyGraphqlQuery)((Object)o);
        return new EqualsBuilder().append((Object)this.projectKey, (Object)that.projectKey).append(this.graphQLRequest, that.graphQLRequest).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.projectKey).append(this.graphQLRequest).toHashCode();
    }

    protected ByProjectKeyGraphqlQuery<T> copy() {
        return new ByProjectKeyGraphqlQuery<T>(this);
    }
}

