/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api;

import com.commercetools.api.models.graph_ql.GraphQLVariablesMap;
import com.commercetools.api.models.graph_ql.GraphQLVariablesMapBuilder;
import com.commercetools.graphql.api.GraphQLData;
import com.commercetools.graphql.api.GraphQLRequest;
import com.commercetools.graphql.api.GraphQLRequestImpl;
import io.vrap.rmf.base.client.Builder;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GraphQLRequestBuilder<T>
implements Builder<GraphQLRequest<T>> {
    private String query;
    @Nullable
    private String operationName;
    @Nullable
    private GraphQLVariablesMap variables;
    @Nullable
    private Function<GraphQLData, T> dataMapper;

    public GraphQLRequestBuilder(String query, @Nullable String operationName, @Nullable GraphQLVariablesMap variables, @Nullable Function<GraphQLData, T> dataMapper) {
        this.query = query;
        this.operationName = operationName;
        this.variables = variables;
        this.dataMapper = dataMapper;
    }

    public GraphQLRequestBuilder() {
    }

    public GraphQLRequestBuilder<T> query(String query) {
        this.query = query;
        return this;
    }

    public GraphQLRequestBuilder<T> operationName(@Nullable String operationName) {
        this.operationName = operationName;
        return this;
    }

    public GraphQLRequestBuilder<T> variables(Function<GraphQLVariablesMapBuilder, GraphQLVariablesMapBuilder> builder) {
        this.variables = builder.apply(GraphQLVariablesMapBuilder.of()).build();
        return this;
    }

    public GraphQLRequestBuilder<T> withVariables(Function<GraphQLVariablesMapBuilder, GraphQLVariablesMap> builder) {
        this.variables = builder.apply(GraphQLVariablesMapBuilder.of());
        return this;
    }

    public GraphQLRequestBuilder<T> variables(@Nullable GraphQLVariablesMap variables) {
        this.variables = variables;
        return this;
    }

    public <TData> GraphQLRequestBuilder<TData> dataMapper(Function<GraphQLData, TData> dataMapper) {
        return new GraphQLRequestBuilder<TData>(this.query, this.operationName, this.variables, dataMapper);
    }

    public String getQuery() {
        return this.query;
    }

    @Nullable
    public String getOperationName() {
        return this.operationName;
    }

    @Nullable
    public GraphQLVariablesMap getVariables() {
        return this.variables;
    }

    @Nullable
    public Function<GraphQLData, T> getDataMapper() {
        return this.dataMapper;
    }

    public GraphQLRequest<T> build() {
        Objects.requireNonNull(this.query, GraphQLRequest.class + ": query is missing");
        Objects.requireNonNull(this.dataMapper, GraphQLRequest.class + ": data mapper is missing");
        return new GraphQLRequestImpl<T>(this.query, this.operationName, this.variables, this.dataMapper);
    }

    public com.commercetools.api.models.graph_ql.GraphQLRequest buildUnchecked() {
        return new GraphQLRequestImpl<T>(this.query, this.operationName, this.variables, this.dataMapper);
    }

    public static <T> GraphQLRequestBuilder<T> of() {
        return new GraphQLRequestBuilder<T>();
    }

    public static <T> GraphQLRequestBuilder<T> of(GraphQLRequest<T> template) {
        GraphQLRequestBuilder<T> builder = new GraphQLRequestBuilder<T>();
        builder.query = template.getQuery();
        builder.operationName = template.getOperationName();
        builder.variables = template.getVariables();
        builder.dataMapper = template.getDataMapper();
        return builder;
    }
}

