/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.OrderEditResult;
import com.commercetools.graphql.api.types.OrderExcerpt;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class Applied
implements OrderEditResult {
    private OffsetDateTime appliedAt;
    private OrderExcerpt excerptBeforeEdit;
    private OrderExcerpt excerptAfterEdit;
    private String type;

    public Applied() {
    }

    public Applied(OffsetDateTime appliedAt, OrderExcerpt excerptBeforeEdit, OrderExcerpt excerptAfterEdit, String type) {
        this.appliedAt = appliedAt;
        this.excerptBeforeEdit = excerptBeforeEdit;
        this.excerptAfterEdit = excerptAfterEdit;
        this.type = type;
    }

    public OffsetDateTime getAppliedAt() {
        return this.appliedAt;
    }

    public void setAppliedAt(OffsetDateTime appliedAt) {
        this.appliedAt = appliedAt;
    }

    public OrderExcerpt getExcerptBeforeEdit() {
        return this.excerptBeforeEdit;
    }

    public void setExcerptBeforeEdit(OrderExcerpt excerptBeforeEdit) {
        this.excerptBeforeEdit = excerptBeforeEdit;
    }

    public OrderExcerpt getExcerptAfterEdit() {
        return this.excerptAfterEdit;
    }

    public void setExcerptAfterEdit(OrderExcerpt excerptAfterEdit) {
        this.excerptAfterEdit = excerptAfterEdit;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "Applied{appliedAt='" + this.appliedAt + "',excerptBeforeEdit='" + this.excerptBeforeEdit + "',excerptAfterEdit='" + this.excerptAfterEdit + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Applied that = (Applied)o;
        return Objects.equals(this.appliedAt, that.appliedAt) && Objects.equals(this.excerptBeforeEdit, that.excerptBeforeEdit) && Objects.equals(this.excerptAfterEdit, that.excerptAfterEdit) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.appliedAt, this.excerptBeforeEdit, this.excerptAfterEdit, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private OffsetDateTime appliedAt;
        private OrderExcerpt excerptBeforeEdit;
        private OrderExcerpt excerptAfterEdit;
        private String type;

        public Applied build() {
            Applied result = new Applied();
            result.appliedAt = this.appliedAt;
            result.excerptBeforeEdit = this.excerptBeforeEdit;
            result.excerptAfterEdit = this.excerptAfterEdit;
            result.type = this.type;
            return result;
        }

        public Builder appliedAt(OffsetDateTime appliedAt) {
            this.appliedAt = appliedAt;
            return this;
        }

        public Builder excerptBeforeEdit(OrderExcerpt excerptBeforeEdit) {
            this.excerptBeforeEdit = excerptBeforeEdit;
            return this;
        }

        public Builder excerptAfterEdit(OrderExcerpt excerptAfterEdit) {
            this.excerptAfterEdit = excerptAfterEdit;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

