/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.Money;
import com.commercetools.graphql.api.types.Reference;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class CartCreated
implements MessagePayload {
    private Money totalPrice;
    private Integer lineItemCount;
    private List<Reference> discountCodesRefs;
    private String type;

    public CartCreated() {
    }

    public CartCreated(Money totalPrice, Integer lineItemCount, List<Reference> discountCodesRefs, String type) {
        this.totalPrice = totalPrice;
        this.lineItemCount = lineItemCount;
        this.discountCodesRefs = discountCodesRefs;
        this.type = type;
    }

    public Money getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(Money totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Integer getLineItemCount() {
        return this.lineItemCount;
    }

    public void setLineItemCount(Integer lineItemCount) {
        this.lineItemCount = lineItemCount;
    }

    public List<Reference> getDiscountCodesRefs() {
        return this.discountCodesRefs;
    }

    public void setDiscountCodesRefs(List<Reference> discountCodesRefs) {
        this.discountCodesRefs = discountCodesRefs;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "CartCreated{totalPrice='" + this.totalPrice + "',lineItemCount='" + this.lineItemCount + "',discountCodesRefs='" + this.discountCodesRefs + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartCreated that = (CartCreated)o;
        return Objects.equals(this.totalPrice, that.totalPrice) && Objects.equals(this.lineItemCount, that.lineItemCount) && Objects.equals(this.discountCodesRefs, that.discountCodesRefs) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.totalPrice, this.lineItemCount, this.discountCodesRefs, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Money totalPrice;
        private Integer lineItemCount;
        private List<Reference> discountCodesRefs;
        private String type;

        public CartCreated build() {
            CartCreated result = new CartCreated();
            result.totalPrice = this.totalPrice;
            result.lineItemCount = this.lineItemCount;
            result.discountCodesRefs = this.discountCodesRefs;
            result.type = this.type;
            return result;
        }

        public Builder totalPrice(Money totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        public Builder lineItemCount(Integer lineItemCount) {
            this.lineItemCount = lineItemCount;
            return this;
        }

        public Builder discountCodesRefs(List<Reference> discountCodesRefs) {
            this.discountCodesRefs = discountCodesRefs;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

