/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomField;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class DateTimeField
implements CustomField {
    private OffsetDateTime value;
    private String name;

    public DateTimeField() {
    }

    public DateTimeField(OffsetDateTime value, String name) {
        this.value = value;
        this.name = name;
    }

    public OffsetDateTime getValue() {
        return this.value;
    }

    public void setValue(OffsetDateTime value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "DateTimeField{value='" + this.value + "',name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeField that = (DateTimeField)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private OffsetDateTime value;
        private String name;

        public DateTimeField build() {
            DateTimeField result = new DateTimeField();
            result.value = this.value;
            result.name = this.name;
            return result;
        }

        public Builder value(OffsetDateTime value) {
            this.value = value;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

