/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CartDiscountValue;
import com.commercetools.graphql.api.types.ChannelReferenceIdentifier;
import com.commercetools.graphql.api.types.ProductReferenceIdentifier;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class GiftLineItemValue
implements CartDiscountValue {
    private String type;
    private Integer variantId;
    private ProductReferenceIdentifier productRef;
    private ChannelReferenceIdentifier distributionChannelRef;
    private ChannelReferenceIdentifier supplyChannelRef;

    public GiftLineItemValue() {
    }

    public GiftLineItemValue(String type, Integer variantId, ProductReferenceIdentifier productRef, ChannelReferenceIdentifier distributionChannelRef, ChannelReferenceIdentifier supplyChannelRef) {
        this.type = type;
        this.variantId = variantId;
        this.productRef = productRef;
        this.distributionChannelRef = distributionChannelRef;
        this.supplyChannelRef = supplyChannelRef;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public void setVariantId(Integer variantId) {
        this.variantId = variantId;
    }

    public ProductReferenceIdentifier getProductRef() {
        return this.productRef;
    }

    public void setProductRef(ProductReferenceIdentifier productRef) {
        this.productRef = productRef;
    }

    public ChannelReferenceIdentifier getDistributionChannelRef() {
        return this.distributionChannelRef;
    }

    public void setDistributionChannelRef(ChannelReferenceIdentifier distributionChannelRef) {
        this.distributionChannelRef = distributionChannelRef;
    }

    public ChannelReferenceIdentifier getSupplyChannelRef() {
        return this.supplyChannelRef;
    }

    public void setSupplyChannelRef(ChannelReferenceIdentifier supplyChannelRef) {
        this.supplyChannelRef = supplyChannelRef;
    }

    public String toString() {
        return "GiftLineItemValue{type='" + this.type + "',variantId='" + this.variantId + "',productRef='" + this.productRef + "',distributionChannelRef='" + this.distributionChannelRef + "',supplyChannelRef='" + this.supplyChannelRef + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GiftLineItemValue that = (GiftLineItemValue)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.variantId, that.variantId) && Objects.equals(this.productRef, that.productRef) && Objects.equals(this.distributionChannelRef, that.distributionChannelRef) && Objects.equals(this.supplyChannelRef, that.supplyChannelRef);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.variantId, this.productRef, this.distributionChannelRef, this.supplyChannelRef);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private Integer variantId;
        private ProductReferenceIdentifier productRef;
        private ChannelReferenceIdentifier distributionChannelRef;
        private ChannelReferenceIdentifier supplyChannelRef;

        public GiftLineItemValue build() {
            GiftLineItemValue result = new GiftLineItemValue();
            result.type = this.type;
            result.variantId = this.variantId;
            result.productRef = this.productRef;
            result.distributionChannelRef = this.distributionChannelRef;
            result.supplyChannelRef = this.supplyChannelRef;
            return result;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder variantId(Integer variantId) {
            this.variantId = variantId;
            return this;
        }

        public Builder productRef(ProductReferenceIdentifier productRef) {
            this.productRef = productRef;
            return this;
        }

        public Builder distributionChannelRef(ChannelReferenceIdentifier distributionChannelRef) {
            this.distributionChannelRef = distributionChannelRef;
            return this;
        }

        public Builder supplyChannelRef(ChannelReferenceIdentifier supplyChannelRef) {
            this.supplyChannelRef = supplyChannelRef;
            return this;
        }
    }
}

