/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.BaseMoney;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Currency;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class HighPrecisionMoney
implements BaseMoney {
    private String type;
    private Currency currencyCode;
    private Long preciseAmount;
    private Long centAmount;
    private Integer fractionDigits;

    public HighPrecisionMoney() {
    }

    public HighPrecisionMoney(String type, Currency currencyCode, Long preciseAmount, Long centAmount, Integer fractionDigits) {
        this.type = type;
        this.currencyCode = currencyCode;
        this.preciseAmount = preciseAmount;
        this.centAmount = centAmount;
        this.fractionDigits = fractionDigits;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Currency getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public void setCurrencyCode(Currency currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Long getPreciseAmount() {
        return this.preciseAmount;
    }

    public void setPreciseAmount(Long preciseAmount) {
        this.preciseAmount = preciseAmount;
    }

    @Override
    public Long getCentAmount() {
        return this.centAmount;
    }

    @Override
    public void setCentAmount(Long centAmount) {
        this.centAmount = centAmount;
    }

    @Override
    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public void setFractionDigits(Integer fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String toString() {
        return "HighPrecisionMoney{type='" + this.type + "',currencyCode='" + this.currencyCode + "',preciseAmount='" + this.preciseAmount + "',centAmount='" + this.centAmount + "',fractionDigits='" + this.fractionDigits + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighPrecisionMoney that = (HighPrecisionMoney)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.currencyCode, that.currencyCode) && Objects.equals(this.preciseAmount, that.preciseAmount) && Objects.equals(this.centAmount, that.centAmount) && Objects.equals(this.fractionDigits, that.fractionDigits);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.currencyCode, this.preciseAmount, this.centAmount, this.fractionDigits);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private Currency currencyCode;
        private Long preciseAmount;
        private Long centAmount;
        private Integer fractionDigits;

        public HighPrecisionMoney build() {
            HighPrecisionMoney result = new HighPrecisionMoney();
            result.type = this.type;
            result.currencyCode = this.currencyCode;
            result.preciseAmount = this.preciseAmount;
            result.centAmount = this.centAmount;
            result.fractionDigits = this.fractionDigits;
            return result;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder currencyCode(Currency currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder preciseAmount(Long preciseAmount) {
            this.preciseAmount = preciseAmount;
            return this;
        }

        public Builder centAmount(Long centAmount) {
            this.centAmount = centAmount;
            return this;
        }

        public Builder fractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
            return this;
        }
    }
}

