/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Dimensions;
import java.util.Objects;

public class Image {
    private String url;
    private Dimensions dimensions;
    private String label;

    public Image() {
    }

    public Image(String url, Dimensions dimensions, String label) {
        this.url = url;
        this.dimensions = dimensions;
        this.label = label;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return "Image{url='" + this.url + "',dimensions='" + this.dimensions + "',label='" + this.label + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image that = (Image)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.dimensions, this.label);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private Dimensions dimensions;
        private String label;

        public Image build() {
            Image result = new Image();
            result.url = this.url;
            result.dimensions = this.dimensions;
            result.label = this.label;
            return result;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder dimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }
    }
}

