/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Reference;
import com.commercetools.graphql.api.types.State;
import java.util.Objects;

public class ItemState {
    private Long quantity;
    private Reference stateRef;
    private State state;

    public ItemState() {
    }

    public ItemState(Long quantity, Reference stateRef, State state) {
        this.quantity = quantity;
        this.stateRef = stateRef;
        this.state = state;
    }

    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public Reference getStateRef() {
        return this.stateRef;
    }

    public void setStateRef(Reference stateRef) {
        this.stateRef = stateRef;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String toString() {
        return "ItemState{quantity='" + this.quantity + "',stateRef='" + this.stateRef + "',state='" + this.state + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemState that = (ItemState)o;
        return Objects.equals(this.quantity, that.quantity) && Objects.equals(this.stateRef, that.stateRef) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.stateRef, this.state);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Long quantity;
        private Reference stateRef;
        private State state;

        public ItemState build() {
            ItemState result = new ItemState();
            result.quantity = this.quantity;
            result.stateRef = this.stateRef;
            result.state = this.state;
            return result;
        }

        public Builder quantity(Long quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder stateRef(Reference stateRef) {
            this.stateRef = stateRef;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }
    }
}

