/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.DiscountedLineItemPriceForQuantity;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.TaxedItemPrice;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class OrderCustomLineItemDiscountSet
implements MessagePayload,
OrderMessagePayload {
    private String customLineItemId;
    private String customLineItemKey;
    private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;
    private TaxedItemPrice taxedPrice;
    private String type;

    public OrderCustomLineItemDiscountSet() {
    }

    public OrderCustomLineItemDiscountSet(String customLineItemId, String customLineItemKey, List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity, TaxedItemPrice taxedPrice, String type) {
        this.customLineItemId = customLineItemId;
        this.customLineItemKey = customLineItemKey;
        this.discountedPricePerQuantity = discountedPricePerQuantity;
        this.taxedPrice = taxedPrice;
        this.type = type;
    }

    public String getCustomLineItemId() {
        return this.customLineItemId;
    }

    public void setCustomLineItemId(String customLineItemId) {
        this.customLineItemId = customLineItemId;
    }

    public String getCustomLineItemKey() {
        return this.customLineItemKey;
    }

    public void setCustomLineItemKey(String customLineItemKey) {
        this.customLineItemKey = customLineItemKey;
    }

    public List<DiscountedLineItemPriceForQuantity> getDiscountedPricePerQuantity() {
        return this.discountedPricePerQuantity;
    }

    public void setDiscountedPricePerQuantity(List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
        this.discountedPricePerQuantity = discountedPricePerQuantity;
    }

    public TaxedItemPrice getTaxedPrice() {
        return this.taxedPrice;
    }

    public void setTaxedPrice(TaxedItemPrice taxedPrice) {
        this.taxedPrice = taxedPrice;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "OrderCustomLineItemDiscountSet{customLineItemId='" + this.customLineItemId + "',customLineItemKey='" + this.customLineItemKey + "',discountedPricePerQuantity='" + this.discountedPricePerQuantity + "',taxedPrice='" + this.taxedPrice + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderCustomLineItemDiscountSet that = (OrderCustomLineItemDiscountSet)o;
        return Objects.equals(this.customLineItemId, that.customLineItemId) && Objects.equals(this.customLineItemKey, that.customLineItemKey) && Objects.equals(this.discountedPricePerQuantity, that.discountedPricePerQuantity) && Objects.equals(this.taxedPrice, that.taxedPrice) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.customLineItemId, this.customLineItemKey, this.discountedPricePerQuantity, this.taxedPrice, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String customLineItemId;
        private String customLineItemKey;
        private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;
        private TaxedItemPrice taxedPrice;
        private String type;

        public OrderCustomLineItemDiscountSet build() {
            OrderCustomLineItemDiscountSet result = new OrderCustomLineItemDiscountSet();
            result.customLineItemId = this.customLineItemId;
            result.customLineItemKey = this.customLineItemKey;
            result.discountedPricePerQuantity = this.discountedPricePerQuantity;
            result.taxedPrice = this.taxedPrice;
            result.type = this.type;
            return result;
        }

        public Builder customLineItemId(String customLineItemId) {
            this.customLineItemId = customLineItemId;
            return this;
        }

        public Builder customLineItemKey(String customLineItemKey) {
            this.customLineItemKey = customLineItemKey;
            return this;
        }

        public Builder discountedPricePerQuantity(List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
            this.discountedPricePerQuantity = discountedPricePerQuantity;
            return this;
        }

        public Builder taxedPrice(TaxedItemPrice taxedPrice) {
            this.taxedPrice = taxedPrice;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

