/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Money;
import com.commercetools.graphql.api.types.TaxedPrice;
import java.util.Objects;

public class OrderExcerpt {
    private Money totalPrice;
    private TaxedPrice taxedPrice;
    private Long version;

    public OrderExcerpt() {
    }

    public OrderExcerpt(Money totalPrice, TaxedPrice taxedPrice, Long version) {
        this.totalPrice = totalPrice;
        this.taxedPrice = taxedPrice;
        this.version = version;
    }

    public Money getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(Money totalPrice) {
        this.totalPrice = totalPrice;
    }

    public TaxedPrice getTaxedPrice() {
        return this.taxedPrice;
    }

    public void setTaxedPrice(TaxedPrice taxedPrice) {
        this.taxedPrice = taxedPrice;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String toString() {
        return "OrderExcerpt{totalPrice='" + this.totalPrice + "',taxedPrice='" + this.taxedPrice + "',version='" + this.version + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderExcerpt that = (OrderExcerpt)o;
        return Objects.equals(this.totalPrice, that.totalPrice) && Objects.equals(this.taxedPrice, that.taxedPrice) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.totalPrice, this.taxedPrice, this.version);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Money totalPrice;
        private TaxedPrice taxedPrice;
        private Long version;

        public OrderExcerpt build() {
            OrderExcerpt result = new OrderExcerpt();
            result.totalPrice = this.totalPrice;
            result.taxedPrice = this.taxedPrice;
            result.version = this.version;
            return result;
        }

        public Builder totalPrice(Money totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        public Builder taxedPrice(TaxedPrice taxedPrice) {
            this.taxedPrice = taxedPrice;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }
    }
}

