/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.LineItem;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class OrderLineItemAdded
implements MessagePayload,
OrderMessagePayload {
    private LineItem lineItem;
    private Long addedQuantity;
    private String type;

    public OrderLineItemAdded() {
    }

    public OrderLineItemAdded(LineItem lineItem, Long addedQuantity, String type) {
        this.lineItem = lineItem;
        this.addedQuantity = addedQuantity;
        this.type = type;
    }

    public LineItem getLineItem() {
        return this.lineItem;
    }

    public void setLineItem(LineItem lineItem) {
        this.lineItem = lineItem;
    }

    public Long getAddedQuantity() {
        return this.addedQuantity;
    }

    public void setAddedQuantity(Long addedQuantity) {
        this.addedQuantity = addedQuantity;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "OrderLineItemAdded{lineItem='" + this.lineItem + "',addedQuantity='" + this.addedQuantity + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItemAdded that = (OrderLineItemAdded)o;
        return Objects.equals(this.lineItem, that.lineItem) && Objects.equals(this.addedQuantity, that.addedQuantity) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.lineItem, this.addedQuantity, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private LineItem lineItem;
        private Long addedQuantity;
        private String type;

        public OrderLineItemAdded build() {
            OrderLineItemAdded result = new OrderLineItemAdded();
            result.lineItem = this.lineItem;
            result.addedQuantity = this.addedQuantity;
            result.type = this.type;
            return result;
        }

        public Builder lineItem(LineItem lineItem) {
            this.lineItem = lineItem;
            return this;
        }

        public Builder addedQuantity(Long addedQuantity) {
            this.addedQuantity = addedQuantity;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

