/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Address;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class OrderShippingAddressSet
implements MessagePayload,
OrderMessagePayload {
    private Address address;
    private Address oldAddress;
    private String type;

    public OrderShippingAddressSet() {
    }

    public OrderShippingAddressSet(Address address, Address oldAddress, String type) {
        this.address = address;
        this.oldAddress = oldAddress;
        this.type = type;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getOldAddress() {
        return this.oldAddress;
    }

    public void setOldAddress(Address oldAddress) {
        this.oldAddress = oldAddress;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "OrderShippingAddressSet{address='" + this.address + "',oldAddress='" + this.oldAddress + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderShippingAddressSet that = (OrderShippingAddressSet)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.oldAddress, that.oldAddress) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.oldAddress, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Address address;
        private Address oldAddress;
        private String type;

        public OrderShippingAddressSet build() {
            OrderShippingAddressSet result = new OrderShippingAddressSet();
            result.address = this.address;
            result.oldAddress = this.oldAddress;
            result.type = this.type;
            return result;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder oldAddress(Address oldAddress) {
            this.oldAddress = oldAddress;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

