/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomFieldsType;
import com.commercetools.graphql.api.types.DeliveryItem;
import com.commercetools.graphql.api.types.ParcelMeasurements;
import com.commercetools.graphql.api.types.TrackingData;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class Parcel {
    private String id;
    private String key;
    private OffsetDateTime createdAt;
    private ParcelMeasurements measurements;
    private TrackingData trackingData;
    private List<DeliveryItem> items;
    private CustomFieldsType custom;

    public Parcel() {
    }

    public Parcel(String id, String key, OffsetDateTime createdAt, ParcelMeasurements measurements, TrackingData trackingData, List<DeliveryItem> items, CustomFieldsType custom) {
        this.id = id;
        this.key = key;
        this.createdAt = createdAt;
        this.measurements = measurements;
        this.trackingData = trackingData;
        this.items = items;
        this.custom = custom;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ParcelMeasurements getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(ParcelMeasurements measurements) {
        this.measurements = measurements;
    }

    public TrackingData getTrackingData() {
        return this.trackingData;
    }

    public void setTrackingData(TrackingData trackingData) {
        this.trackingData = trackingData;
    }

    public List<DeliveryItem> getItems() {
        return this.items;
    }

    public void setItems(List<DeliveryItem> items) {
        this.items = items;
    }

    public CustomFieldsType getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsType custom) {
        this.custom = custom;
    }

    public String toString() {
        return "Parcel{id='" + this.id + "',key='" + this.key + "',createdAt='" + this.createdAt + "',measurements='" + this.measurements + "',trackingData='" + this.trackingData + "',items='" + this.items + "',custom='" + this.custom + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parcel that = (Parcel)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.trackingData, that.trackingData) && Objects.equals(this.items, that.items) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.createdAt, this.measurements, this.trackingData, this.items, this.custom);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String key;
        private OffsetDateTime createdAt;
        private ParcelMeasurements measurements;
        private TrackingData trackingData;
        private List<DeliveryItem> items;
        private CustomFieldsType custom;

        public Parcel build() {
            Parcel result = new Parcel();
            result.id = this.id;
            result.key = this.key;
            result.createdAt = this.createdAt;
            result.measurements = this.measurements;
            result.trackingData = this.trackingData;
            result.items = this.items;
            result.custom = this.custom;
            return result;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder measurements(ParcelMeasurements measurements) {
            this.measurements = measurements;
            return this;
        }

        public Builder trackingData(TrackingData trackingData) {
            this.trackingData = trackingData;
            return this;
        }

        public Builder items(List<DeliveryItem> items) {
            this.items = items;
            return this;
        }

        public Builder custom(CustomFieldsType custom) {
            this.custom = custom;
            return this;
        }
    }
}

