/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Delivery;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.Parcel;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ParcelAddedToDelivery
implements MessagePayload,
OrderMessagePayload {
    private Delivery delivery;
    private Parcel parcel;
    private String shippingKey;
    private String type;

    public ParcelAddedToDelivery() {
    }

    public ParcelAddedToDelivery(Delivery delivery, Parcel parcel, String shippingKey, String type) {
        this.delivery = delivery;
        this.parcel = parcel;
        this.shippingKey = shippingKey;
        this.type = type;
    }

    public Delivery getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    public Parcel getParcel() {
        return this.parcel;
    }

    public void setParcel(Parcel parcel) {
        this.parcel = parcel;
    }

    public String getShippingKey() {
        return this.shippingKey;
    }

    public void setShippingKey(String shippingKey) {
        this.shippingKey = shippingKey;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ParcelAddedToDelivery{delivery='" + this.delivery + "',parcel='" + this.parcel + "',shippingKey='" + this.shippingKey + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelAddedToDelivery that = (ParcelAddedToDelivery)o;
        return Objects.equals(this.delivery, that.delivery) && Objects.equals(this.parcel, that.parcel) && Objects.equals(this.shippingKey, that.shippingKey) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.delivery, this.parcel, this.shippingKey, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Delivery delivery;
        private Parcel parcel;
        private String shippingKey;
        private String type;

        public ParcelAddedToDelivery build() {
            ParcelAddedToDelivery result = new ParcelAddedToDelivery();
            result.delivery = this.delivery;
            result.parcel = this.parcel;
            result.shippingKey = this.shippingKey;
            result.type = this.type;
            return result;
        }

        public Builder delivery(Delivery delivery) {
            this.delivery = delivery;
            return this;
        }

        public Builder parcel(Parcel parcel) {
            this.parcel = parcel;
            return this;
        }

        public Builder shippingKey(String shippingKey) {
            this.shippingKey = shippingKey;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

