/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.DeliveryItem;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ParcelItemsUpdated
implements MessagePayload,
OrderMessagePayload {
    private String deliveryId;
    private String parcelId;
    private List<DeliveryItem> items;
    private List<DeliveryItem> oldItems;
    private String shippingKey;
    private String type;

    public ParcelItemsUpdated() {
    }

    public ParcelItemsUpdated(String deliveryId, String parcelId, List<DeliveryItem> items, List<DeliveryItem> oldItems, String shippingKey, String type) {
        this.deliveryId = deliveryId;
        this.parcelId = parcelId;
        this.items = items;
        this.oldItems = oldItems;
        this.shippingKey = shippingKey;
        this.type = type;
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(String deliveryId) {
        this.deliveryId = deliveryId;
    }

    public String getParcelId() {
        return this.parcelId;
    }

    public void setParcelId(String parcelId) {
        this.parcelId = parcelId;
    }

    public List<DeliveryItem> getItems() {
        return this.items;
    }

    public void setItems(List<DeliveryItem> items) {
        this.items = items;
    }

    public List<DeliveryItem> getOldItems() {
        return this.oldItems;
    }

    public void setOldItems(List<DeliveryItem> oldItems) {
        this.oldItems = oldItems;
    }

    public String getShippingKey() {
        return this.shippingKey;
    }

    public void setShippingKey(String shippingKey) {
        this.shippingKey = shippingKey;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ParcelItemsUpdated{deliveryId='" + this.deliveryId + "',parcelId='" + this.parcelId + "',items='" + this.items + "',oldItems='" + this.oldItems + "',shippingKey='" + this.shippingKey + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelItemsUpdated that = (ParcelItemsUpdated)o;
        return Objects.equals(this.deliveryId, that.deliveryId) && Objects.equals(this.parcelId, that.parcelId) && Objects.equals(this.items, that.items) && Objects.equals(this.oldItems, that.oldItems) && Objects.equals(this.shippingKey, that.shippingKey) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryId, this.parcelId, this.items, this.oldItems, this.shippingKey, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String deliveryId;
        private String parcelId;
        private List<DeliveryItem> items;
        private List<DeliveryItem> oldItems;
        private String shippingKey;
        private String type;

        public ParcelItemsUpdated build() {
            ParcelItemsUpdated result = new ParcelItemsUpdated();
            result.deliveryId = this.deliveryId;
            result.parcelId = this.parcelId;
            result.items = this.items;
            result.oldItems = this.oldItems;
            result.shippingKey = this.shippingKey;
            result.type = this.type;
            return result;
        }

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder parcelId(String parcelId) {
            this.parcelId = parcelId;
            return this;
        }

        public Builder items(List<DeliveryItem> items) {
            this.items = items;
            return this;
        }

        public Builder oldItems(List<DeliveryItem> oldItems) {
            this.oldItems = oldItems;
            return this;
        }

        public Builder shippingKey(String shippingKey) {
            this.shippingKey = shippingKey;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

