/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Order;
import com.commercetools.graphql.api.types.OrderEditResult;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class PreviewSuccess
implements OrderEditResult {
    private String type;
    private Order preview;
    private List<OrderMessagePayload> messagePayloads;

    public PreviewSuccess() {
    }

    public PreviewSuccess(String type, Order preview, List<OrderMessagePayload> messagePayloads) {
        this.type = type;
        this.preview = preview;
        this.messagePayloads = messagePayloads;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Order getPreview() {
        return this.preview;
    }

    public void setPreview(Order preview) {
        this.preview = preview;
    }

    public List<OrderMessagePayload> getMessagePayloads() {
        return this.messagePayloads;
    }

    public void setMessagePayloads(List<OrderMessagePayload> messagePayloads) {
        this.messagePayloads = messagePayloads;
    }

    public String toString() {
        return "PreviewSuccess{type='" + this.type + "',preview='" + this.preview + "',messagePayloads='" + this.messagePayloads + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreviewSuccess that = (PreviewSuccess)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.preview, that.preview) && Objects.equals(this.messagePayloads, that.messagePayloads);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.preview, this.messagePayloads);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private Order preview;
        private List<OrderMessagePayload> messagePayloads;

        public PreviewSuccess build() {
            PreviewSuccess result = new PreviewSuccess();
            result.type = this.type;
            result.preview = this.preview;
            result.messagePayloads = this.messagePayloads;
            return result;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder preview(Order preview) {
            this.preview = preview;
            return this;
        }

        public Builder messagePayloads(List<OrderMessagePayload> messagePayloads) {
            this.messagePayloads = messagePayloads;
            return this;
        }
    }
}

