/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Image;
import com.commercetools.graphql.api.types.MessagePayload;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ProductImageAdded
implements MessagePayload {
    private Integer variantId;
    private Image image;
    private Boolean staged;
    private String type;

    public ProductImageAdded() {
    }

    public ProductImageAdded(Integer variantId, Image image, Boolean staged, String type) {
        this.variantId = variantId;
        this.image = image;
        this.staged = staged;
        this.type = type;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public void setVariantId(Integer variantId) {
        this.variantId = variantId;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Boolean getStaged() {
        return this.staged;
    }

    public void setStaged(Boolean staged) {
        this.staged = staged;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ProductImageAdded{variantId='" + this.variantId + "',image='" + this.image + "',staged='" + this.staged + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductImageAdded that = (ProductImageAdded)o;
        return Objects.equals(this.variantId, that.variantId) && Objects.equals(this.image, that.image) && Objects.equals(this.staged, that.staged) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.variantId, this.image, this.staged, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer variantId;
        private Image image;
        private Boolean staged;
        private String type;

        public ProductImageAdded build() {
            ProductImageAdded result = new ProductImageAdded();
            result.variantId = this.variantId;
            result.image = this.image;
            result.staged = this.staged;
            result.type = this.type;
            return result;
        }

        public Builder variantId(Integer variantId) {
            this.variantId = variantId;
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public Builder staged(Boolean staged) {
            this.staged = staged;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

