/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Customer;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.Reference;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class QuoteCustomerChanged
implements MessagePayload {
    private Reference customerRef;
    private Reference previousCustomerRef;
    private Customer customer;
    private Customer previousCustomer;
    private String type;

    public QuoteCustomerChanged() {
    }

    public QuoteCustomerChanged(Reference customerRef, Reference previousCustomerRef, Customer customer, Customer previousCustomer, String type) {
        this.customerRef = customerRef;
        this.previousCustomerRef = previousCustomerRef;
        this.customer = customer;
        this.previousCustomer = previousCustomer;
        this.type = type;
    }

    public Reference getCustomerRef() {
        return this.customerRef;
    }

    public void setCustomerRef(Reference customerRef) {
        this.customerRef = customerRef;
    }

    public Reference getPreviousCustomerRef() {
        return this.previousCustomerRef;
    }

    public void setPreviousCustomerRef(Reference previousCustomerRef) {
        this.previousCustomerRef = previousCustomerRef;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Customer getPreviousCustomer() {
        return this.previousCustomer;
    }

    public void setPreviousCustomer(Customer previousCustomer) {
        this.previousCustomer = previousCustomer;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "QuoteCustomerChanged{customerRef='" + this.customerRef + "',previousCustomerRef='" + this.previousCustomerRef + "',customer='" + this.customer + "',previousCustomer='" + this.previousCustomer + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuoteCustomerChanged that = (QuoteCustomerChanged)o;
        return Objects.equals(this.customerRef, that.customerRef) && Objects.equals(this.previousCustomerRef, that.previousCustomerRef) && Objects.equals(this.customer, that.customer) && Objects.equals(this.previousCustomer, that.previousCustomer) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.customerRef, this.previousCustomerRef, this.customer, this.previousCustomer, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Reference customerRef;
        private Reference previousCustomerRef;
        private Customer customer;
        private Customer previousCustomer;
        private String type;

        public QuoteCustomerChanged build() {
            QuoteCustomerChanged result = new QuoteCustomerChanged();
            result.customerRef = this.customerRef;
            result.previousCustomerRef = this.previousCustomerRef;
            result.customer = this.customer;
            result.previousCustomer = this.previousCustomer;
            result.type = this.type;
            return result;
        }

        public Builder customerRef(Reference customerRef) {
            this.customerRef = customerRef;
            return this;
        }

        public Builder previousCustomerRef(Reference previousCustomerRef) {
            this.previousCustomerRef = previousCustomerRef;
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public Builder previousCustomer(Customer previousCustomer) {
            this.previousCustomer = previousCustomer;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

