/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.Reference;
import com.commercetools.graphql.api.types.ReviewTarget;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ReviewRatingSet
implements MessagePayload {
    private Integer oldRating;
    private Integer newRating;
    private Boolean includedInStatistics;
    private ReviewTarget target;
    private Reference targetRef;
    private String type;

    public ReviewRatingSet() {
    }

    public ReviewRatingSet(Integer oldRating, Integer newRating, Boolean includedInStatistics, ReviewTarget target, Reference targetRef, String type) {
        this.oldRating = oldRating;
        this.newRating = newRating;
        this.includedInStatistics = includedInStatistics;
        this.target = target;
        this.targetRef = targetRef;
        this.type = type;
    }

    public Integer getOldRating() {
        return this.oldRating;
    }

    public void setOldRating(Integer oldRating) {
        this.oldRating = oldRating;
    }

    public Integer getNewRating() {
        return this.newRating;
    }

    public void setNewRating(Integer newRating) {
        this.newRating = newRating;
    }

    public Boolean getIncludedInStatistics() {
        return this.includedInStatistics;
    }

    public void setIncludedInStatistics(Boolean includedInStatistics) {
        this.includedInStatistics = includedInStatistics;
    }

    public ReviewTarget getTarget() {
        return this.target;
    }

    public void setTarget(ReviewTarget target) {
        this.target = target;
    }

    public Reference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(Reference targetRef) {
        this.targetRef = targetRef;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ReviewRatingSet{oldRating='" + this.oldRating + "',newRating='" + this.newRating + "',includedInStatistics='" + this.includedInStatistics + "',target='" + this.target + "',targetRef='" + this.targetRef + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewRatingSet that = (ReviewRatingSet)o;
        return Objects.equals(this.oldRating, that.oldRating) && Objects.equals(this.newRating, that.newRating) && Objects.equals(this.includedInStatistics, that.includedInStatistics) && Objects.equals(this.target, that.target) && Objects.equals(this.targetRef, that.targetRef) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.oldRating, this.newRating, this.includedInStatistics, this.target, this.targetRef, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer oldRating;
        private Integer newRating;
        private Boolean includedInStatistics;
        private ReviewTarget target;
        private Reference targetRef;
        private String type;

        public ReviewRatingSet build() {
            ReviewRatingSet result = new ReviewRatingSet();
            result.oldRating = this.oldRating;
            result.newRating = this.newRating;
            result.includedInStatistics = this.includedInStatistics;
            result.target = this.target;
            result.targetRef = this.targetRef;
            result.type = this.type;
            return result;
        }

        public Builder oldRating(Integer oldRating) {
            this.oldRating = oldRating;
            return this;
        }

        public Builder newRating(Integer newRating) {
            this.newRating = newRating;
            return this;
        }

        public Builder includedInStatistics(Boolean includedInStatistics) {
            this.includedInStatistics = includedInStatistics;
            return this;
        }

        public Builder target(ReviewTarget target) {
            this.target = target;
            return this;
        }

        public Builder targetRef(Reference targetRef) {
            this.targetRef = targetRef;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

