/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Money;
import com.commercetools.graphql.api.types.TaxPortion;
import java.util.List;
import java.util.Objects;

public class TaxedItemPrice {
    private Money totalNet;
    private Money totalGross;
    private List<TaxPortion> taxPortions;
    private Money totalTax;

    public TaxedItemPrice() {
    }

    public TaxedItemPrice(Money totalNet, Money totalGross, List<TaxPortion> taxPortions, Money totalTax) {
        this.totalNet = totalNet;
        this.totalGross = totalGross;
        this.taxPortions = taxPortions;
        this.totalTax = totalTax;
    }

    public Money getTotalNet() {
        return this.totalNet;
    }

    public void setTotalNet(Money totalNet) {
        this.totalNet = totalNet;
    }

    public Money getTotalGross() {
        return this.totalGross;
    }

    public void setTotalGross(Money totalGross) {
        this.totalGross = totalGross;
    }

    public List<TaxPortion> getTaxPortions() {
        return this.taxPortions;
    }

    public void setTaxPortions(List<TaxPortion> taxPortions) {
        this.taxPortions = taxPortions;
    }

    public Money getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Money totalTax) {
        this.totalTax = totalTax;
    }

    public String toString() {
        return "TaxedItemPrice{totalNet='" + this.totalNet + "',totalGross='" + this.totalGross + "',taxPortions='" + this.taxPortions + "',totalTax='" + this.totalTax + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxedItemPrice that = (TaxedItemPrice)o;
        return Objects.equals(this.totalNet, that.totalNet) && Objects.equals(this.totalGross, that.totalGross) && Objects.equals(this.taxPortions, that.taxPortions) && Objects.equals(this.totalTax, that.totalTax);
    }

    public int hashCode() {
        return Objects.hash(this.totalNet, this.totalGross, this.taxPortions, this.totalTax);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Money totalNet;
        private Money totalGross;
        private List<TaxPortion> taxPortions;
        private Money totalTax;

        public TaxedItemPrice build() {
            TaxedItemPrice result = new TaxedItemPrice();
            result.totalNet = this.totalNet;
            result.totalGross = this.totalGross;
            result.taxPortions = this.taxPortions;
            result.totalTax = this.totalTax;
            return result;
        }

        public Builder totalNet(Money totalNet) {
            this.totalNet = totalNet;
            return this;
        }

        public Builder totalGross(Money totalGross) {
            this.totalGross = totalGross;
            return this;
        }

        public Builder taxPortions(List<TaxPortion> taxPortions) {
            this.taxPortions = taxPortions;
            return this;
        }

        public Builder totalTax(Money totalTax) {
            this.totalTax = totalTax;
            return this;
        }
    }
}

