/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomFieldsType;
import com.commercetools.graphql.api.types.Money;
import com.commercetools.graphql.api.types.TransactionState;
import com.commercetools.graphql.api.types.TransactionType;
import java.time.OffsetDateTime;
import java.util.Objects;

public class Transaction {
    private String id;
    private OffsetDateTime timestamp;
    private TransactionType type;
    private Money amount;
    private String interactionId;
    private TransactionState state;
    private CustomFieldsType custom;

    public Transaction() {
    }

    public Transaction(String id, OffsetDateTime timestamp, TransactionType type, Money amount, String interactionId, TransactionState state, CustomFieldsType custom) {
        this.id = id;
        this.timestamp = timestamp;
        this.type = type;
        this.amount = amount;
        this.interactionId = interactionId;
        this.state = state;
        this.custom = custom;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public TransactionType getType() {
        return this.type;
    }

    public void setType(TransactionType type) {
        this.type = type;
    }

    public Money getAmount() {
        return this.amount;
    }

    public void setAmount(Money amount) {
        this.amount = amount;
    }

    public String getInteractionId() {
        return this.interactionId;
    }

    public void setInteractionId(String interactionId) {
        this.interactionId = interactionId;
    }

    public TransactionState getState() {
        return this.state;
    }

    public void setState(TransactionState state) {
        this.state = state;
    }

    public CustomFieldsType getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsType custom) {
        this.custom = custom;
    }

    public String toString() {
        return "Transaction{id='" + this.id + "',timestamp='" + this.timestamp + "',type='" + (Object)((Object)this.type) + "',amount='" + this.amount + "',interactionId='" + this.interactionId + "',state='" + (Object)((Object)this.state) + "',custom='" + this.custom + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.amount, that.amount) && Objects.equals(this.interactionId, that.interactionId) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.timestamp, this.type, this.amount, this.interactionId, this.state, this.custom});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private OffsetDateTime timestamp;
        private TransactionType type;
        private Money amount;
        private String interactionId;
        private TransactionState state;
        private CustomFieldsType custom;

        public Transaction build() {
            Transaction result = new Transaction();
            result.id = this.id;
            result.timestamp = this.timestamp;
            result.type = this.type;
            result.amount = this.amount;
            result.interactionId = this.interactionId;
            result.state = this.state;
            result.custom = this.custom;
            return result;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder type(TransactionType type) {
            this.type = type;
            return this;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder interactionId(String interactionId) {
            this.interactionId = interactionId;
            return this;
        }

        public Builder state(TransactionState state) {
            this.state = state;
            return this;
        }

        public Builder custom(CustomFieldsType custom) {
            this.custom = custom;
            return this;
        }
    }
}

