/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api;

import com.commercetools.api.models.graph_ql.GraphQLError;
import com.commercetools.api.models.graph_ql.GraphQLErrorBuilder;
import com.commercetools.graphql.api.GraphQLData;
import com.commercetools.graphql.api.GraphQLDataResponse;
import com.commercetools.graphql.api.GraphQLDataResponseImpl;
import io.vrap.rmf.base.client.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GraphQLDataResponseBuilder
implements Builder<GraphQLDataResponse> {
    @Nullable
    private GraphQLData data;
    @Nullable
    private List<GraphQLError> errors;

    public GraphQLDataResponseBuilder data(@Nullable GraphQLData data) {
        this.data = data;
        return this;
    }

    public GraphQLDataResponseBuilder errors(GraphQLError ... errors) {
        this.errors = new ArrayList<GraphQLError>(Arrays.asList(errors));
        return this;
    }

    public GraphQLDataResponseBuilder errors(@Nullable List<GraphQLError> errors) {
        this.errors = errors;
        return this;
    }

    public GraphQLDataResponseBuilder plusErrors(GraphQLError ... errors) {
        if (this.errors == null) {
            this.errors = new ArrayList<GraphQLError>();
        }
        this.errors.addAll(Arrays.asList(errors));
        return this;
    }

    public GraphQLDataResponseBuilder plusErrors(Function<GraphQLErrorBuilder, GraphQLErrorBuilder> builder) {
        if (this.errors == null) {
            this.errors = new ArrayList<GraphQLError>();
        }
        this.errors.add(builder.apply(GraphQLErrorBuilder.of()).build());
        return this;
    }

    public GraphQLDataResponseBuilder withErrors(Function<GraphQLErrorBuilder, GraphQLErrorBuilder> builder) {
        this.errors = new ArrayList<GraphQLError>();
        this.errors.add(builder.apply(GraphQLErrorBuilder.of()).build());
        return this;
    }

    public GraphQLDataResponseBuilder addErrors(Function<GraphQLErrorBuilder, GraphQLError> builder) {
        return this.plusErrors(builder.apply(GraphQLErrorBuilder.of()));
    }

    public GraphQLDataResponseBuilder setErrors(Function<GraphQLErrorBuilder, GraphQLError> builder) {
        return this.errors(builder.apply(GraphQLErrorBuilder.of()));
    }

    @Nullable
    public GraphQLData getData() {
        return this.data;
    }

    @Nullable
    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public GraphQLDataResponse build() {
        return new GraphQLDataResponseImpl(this.data, this.errors);
    }

    public GraphQLDataResponse buildUnchecked() {
        return new GraphQLDataResponseImpl(this.data, this.errors);
    }

    public static GraphQLDataResponseBuilder of() {
        return new GraphQLDataResponseBuilder();
    }

    public static GraphQLDataResponseBuilder of(GraphQLDataResponse template) {
        GraphQLDataResponseBuilder builder = new GraphQLDataResponseBuilder();
        builder.data = template.getData();
        builder.errors = template.getErrors();
        return builder;
    }
}

