/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CartDiscountValue;
import com.commercetools.graphql.api.types.DiscountApplicationMode;
import com.commercetools.graphql.api.types.Money;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class AbsoluteCartDiscountValue
implements CartDiscountValue {
    private List<Money> money;
    private DiscountApplicationMode applicationMode;
    private String type;

    public AbsoluteCartDiscountValue() {
    }

    public AbsoluteCartDiscountValue(List<Money> money, DiscountApplicationMode applicationMode, String type) {
        this.money = money;
        this.applicationMode = applicationMode;
        this.type = type;
    }

    public List<Money> getMoney() {
        return this.money;
    }

    public void setMoney(List<Money> money) {
        this.money = money;
    }

    public DiscountApplicationMode getApplicationMode() {
        return this.applicationMode;
    }

    public void setApplicationMode(DiscountApplicationMode applicationMode) {
        this.applicationMode = applicationMode;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "AbsoluteCartDiscountValue{money='" + this.money + "',applicationMode='" + (Object)((Object)this.applicationMode) + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbsoluteCartDiscountValue that = (AbsoluteCartDiscountValue)o;
        return Objects.equals(this.money, that.money) && Objects.equals((Object)this.applicationMode, (Object)that.applicationMode) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.money, this.applicationMode, this.type});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<Money> money;
        private DiscountApplicationMode applicationMode;
        private String type;

        public AbsoluteCartDiscountValue build() {
            AbsoluteCartDiscountValue result = new AbsoluteCartDiscountValue();
            result.money = this.money;
            result.applicationMode = this.applicationMode;
            result.type = this.type;
            return result;
        }

        public Builder money(List<Money> money) {
            this.money = money;
            return this;
        }

        public Builder applicationMode(DiscountApplicationMode applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

