/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.AssetDraftInput;
import com.commercetools.graphql.api.types.ImageInput;
import com.commercetools.graphql.api.types.ProductAttributeInput;
import com.commercetools.graphql.api.types.ProductPriceDataInput;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddProductVariant {
    private List<AssetDraftInput> assets = Collections.emptyList();
    private List<ProductAttributeInput> attributes = Collections.emptyList();
    private List<ImageInput> images = Collections.emptyList();
    private List<ProductPriceDataInput> prices = Collections.emptyList();
    private String key;
    private String sku;
    private Boolean staged = true;

    public AddProductVariant() {
    }

    public AddProductVariant(List<AssetDraftInput> assets, List<ProductAttributeInput> attributes, List<ImageInput> images, List<ProductPriceDataInput> prices, String key, String sku, Boolean staged) {
        this.assets = assets;
        this.attributes = attributes;
        this.images = images;
        this.prices = prices;
        this.key = key;
        this.sku = sku;
        this.staged = staged;
    }

    public List<AssetDraftInput> getAssets() {
        return this.assets;
    }

    public void setAssets(List<AssetDraftInput> assets) {
        this.assets = assets;
    }

    public List<ProductAttributeInput> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ProductAttributeInput> attributes) {
        this.attributes = attributes;
    }

    public List<ImageInput> getImages() {
        return this.images;
    }

    public void setImages(List<ImageInput> images) {
        this.images = images;
    }

    public List<ProductPriceDataInput> getPrices() {
        return this.prices;
    }

    public void setPrices(List<ProductPriceDataInput> prices) {
        this.prices = prices;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Boolean getStaged() {
        return this.staged;
    }

    public void setStaged(Boolean staged) {
        this.staged = staged;
    }

    public String toString() {
        return "AddProductVariant{assets='" + this.assets + "',attributes='" + this.attributes + "',images='" + this.images + "',prices='" + this.prices + "',key='" + this.key + "',sku='" + this.sku + "',staged='" + this.staged + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddProductVariant that = (AddProductVariant)o;
        return Objects.equals(this.assets, that.assets) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.images, that.images) && Objects.equals(this.prices, that.prices) && Objects.equals(this.key, that.key) && Objects.equals(this.sku, that.sku) && Objects.equals(this.staged, that.staged);
    }

    public int hashCode() {
        return Objects.hash(this.assets, this.attributes, this.images, this.prices, this.key, this.sku, this.staged);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<AssetDraftInput> assets = Collections.emptyList();
        private List<ProductAttributeInput> attributes = Collections.emptyList();
        private List<ImageInput> images = Collections.emptyList();
        private List<ProductPriceDataInput> prices = Collections.emptyList();
        private String key;
        private String sku;
        private Boolean staged = true;

        public AddProductVariant build() {
            AddProductVariant result = new AddProductVariant();
            result.assets = this.assets;
            result.attributes = this.attributes;
            result.images = this.images;
            result.prices = this.prices;
            result.key = this.key;
            result.sku = this.sku;
            result.staged = this.staged;
            return result;
        }

        public Builder assets(List<AssetDraftInput> assets) {
            this.assets = assets;
            return this;
        }

        public Builder attributes(List<ProductAttributeInput> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder images(List<ImageInput> images) {
            this.images = images;
            return this;
        }

        public Builder prices(List<ProductPriceDataInput> prices) {
            this.prices = prices;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder staged(Boolean staged) {
            this.staged = staged;
            return this;
        }
    }
}

