/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.AssetDimensions;
import java.util.Objects;

public class AssetSource {
    private String uri;
    private String key;
    private AssetDimensions dimensions;
    private String contentType;

    public AssetSource() {
    }

    public AssetSource(String uri, String key, AssetDimensions dimensions, String contentType) {
        this.uri = uri;
        this.key = key;
        this.dimensions = dimensions;
        this.contentType = contentType;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public AssetDimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(AssetDimensions dimensions) {
        this.dimensions = dimensions;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String toString() {
        return "AssetSource{uri='" + this.uri + "',key='" + this.key + "',dimensions='" + this.dimensions + "',contentType='" + this.contentType + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetSource that = (AssetSource)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.key, that.key) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.key, this.dimensions, this.contentType);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String uri;
        private String key;
        private AssetDimensions dimensions;
        private String contentType;

        public AssetSource build() {
            AssetSource result = new AssetSource();
            result.uri = this.uri;
            result.key = this.key;
            result.dimensions = this.dimensions;
            result.contentType = this.contentType;
            return result;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder dimensions(AssetDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }
    }
}

