/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.AttributionSource;
import com.commercetools.graphql.api.types.Reference;
import java.util.Objects;

public class Attribution {
    private String clientId;
    private AttributionSource source;
    private Reference userRef;

    public Attribution() {
    }

    public Attribution(String clientId, AttributionSource source, Reference userRef) {
        this.clientId = clientId;
        this.source = source;
        this.userRef = userRef;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AttributionSource getSource() {
        return this.source;
    }

    public void setSource(AttributionSource source) {
        this.source = source;
    }

    public Reference getUserRef() {
        return this.userRef;
    }

    public void setUserRef(Reference userRef) {
        this.userRef = userRef;
    }

    public String toString() {
        return "Attribution{clientId='" + this.clientId + "',source='" + (Object)((Object)this.source) + "',userRef='" + this.userRef + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribution that = (Attribution)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals((Object)this.source, (Object)that.source) && Objects.equals(this.userRef, that.userRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.source, this.userRef});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String clientId;
        private AttributionSource source;
        private Reference userRef;

        public Attribution build() {
            Attribution result = new Attribution();
            result.clientId = this.clientId;
            result.source = this.source;
            result.userRef = this.userRef;
            return result;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder source(AttributionSource source) {
            this.source = source;
            return this;
        }

        public Builder userRef(Reference userRef) {
            this.userRef = userRef;
            return this;
        }
    }
}

