/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.EnumValue;
import com.commercetools.graphql.api.types.FieldType;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class EnumType
implements FieldType {
    private List<EnumValue> values;
    private String name;

    public EnumType() {
    }

    public EnumType(List<EnumValue> values, String name) {
        this.values = values;
        this.name = name;
    }

    public List<EnumValue> getValues() {
        return this.values;
    }

    public void setValues(List<EnumValue> values) {
        this.values = values;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "EnumType{values='" + this.values + "',name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumType that = (EnumType)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<EnumValue> values;
        private String name;

        public EnumType build() {
            EnumType result = new EnumType();
            result.values = this.values;
            result.name = this.name;
            return result;
        }

        public Builder values(List<EnumValue> values) {
            this.values = values;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

