/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.AddressInput;
import com.commercetools.graphql.api.types.CartOrigin;
import com.commercetools.graphql.api.types.CustomFieldsDraft;
import com.commercetools.graphql.api.types.CustomLineItemImportDraft;
import com.commercetools.graphql.api.types.InventoryMode;
import com.commercetools.graphql.api.types.ItemShippingDetailsDraft;
import com.commercetools.graphql.api.types.LineItemImportDraft;
import com.commercetools.graphql.api.types.MoneyInput;
import com.commercetools.graphql.api.types.OrderState;
import com.commercetools.graphql.api.types.PaymentState;
import com.commercetools.graphql.api.types.ReferenceInput;
import com.commercetools.graphql.api.types.ShipmentState;
import com.commercetools.graphql.api.types.ShippingInfoImportDraft;
import com.commercetools.graphql.api.types.TaxCalculationMode;
import com.commercetools.graphql.api.types.TaxedPriceDraft;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ImportOrderDraft {
    private String orderNumber;
    private String customerId;
    private String customerEmail;
    private ReferenceInput store;
    private List<LineItemImportDraft> lineItems = Collections.emptyList();
    private List<CustomLineItemImportDraft> customLineItems = Collections.emptyList();
    private MoneyInput totalPrice;
    private TaxedPriceDraft taxedPrice;
    private AddressInput shippingAddress;
    private AddressInput billingAddress;
    private ReferenceInput customerGroup;
    private String country;
    private OrderState orderState;
    private ShipmentState shipmentState;
    private PaymentState paymentState;
    private ShippingInfoImportDraft shippingInfo;
    private OffsetDateTime completedAt;
    private CustomFieldsDraft custom;
    private InventoryMode inventoryMode = InventoryMode.None;
    private ItemShippingDetailsDraft shippingDetails;
    private TaxCalculationMode taxCalculationMode = TaxCalculationMode.LineItemLevel;
    private CartOrigin origin = CartOrigin.Customer;
    private List<AddressInput> itemShippingAddresses = Collections.emptyList();
    private ReferenceInput state;
    private ReferenceInput paymentInfo;
    private String purchaseOrderNumber;

    public ImportOrderDraft() {
    }

    public ImportOrderDraft(String orderNumber, String customerId, String customerEmail, ReferenceInput store, List<LineItemImportDraft> lineItems, List<CustomLineItemImportDraft> customLineItems, MoneyInput totalPrice, TaxedPriceDraft taxedPrice, AddressInput shippingAddress, AddressInput billingAddress, ReferenceInput customerGroup, String country, OrderState orderState, ShipmentState shipmentState, PaymentState paymentState, ShippingInfoImportDraft shippingInfo, OffsetDateTime completedAt, CustomFieldsDraft custom, InventoryMode inventoryMode, ItemShippingDetailsDraft shippingDetails, TaxCalculationMode taxCalculationMode, CartOrigin origin, List<AddressInput> itemShippingAddresses, ReferenceInput state, ReferenceInput paymentInfo, String purchaseOrderNumber) {
        this.orderNumber = orderNumber;
        this.customerId = customerId;
        this.customerEmail = customerEmail;
        this.store = store;
        this.lineItems = lineItems;
        this.customLineItems = customLineItems;
        this.totalPrice = totalPrice;
        this.taxedPrice = taxedPrice;
        this.shippingAddress = shippingAddress;
        this.billingAddress = billingAddress;
        this.customerGroup = customerGroup;
        this.country = country;
        this.orderState = orderState;
        this.shipmentState = shipmentState;
        this.paymentState = paymentState;
        this.shippingInfo = shippingInfo;
        this.completedAt = completedAt;
        this.custom = custom;
        this.inventoryMode = inventoryMode;
        this.shippingDetails = shippingDetails;
        this.taxCalculationMode = taxCalculationMode;
        this.origin = origin;
        this.itemShippingAddresses = itemShippingAddresses;
        this.state = state;
        this.paymentInfo = paymentInfo;
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public ReferenceInput getStore() {
        return this.store;
    }

    public void setStore(ReferenceInput store) {
        this.store = store;
    }

    public List<LineItemImportDraft> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemImportDraft> lineItems) {
        this.lineItems = lineItems;
    }

    public List<CustomLineItemImportDraft> getCustomLineItems() {
        return this.customLineItems;
    }

    public void setCustomLineItems(List<CustomLineItemImportDraft> customLineItems) {
        this.customLineItems = customLineItems;
    }

    public MoneyInput getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(MoneyInput totalPrice) {
        this.totalPrice = totalPrice;
    }

    public TaxedPriceDraft getTaxedPrice() {
        return this.taxedPrice;
    }

    public void setTaxedPrice(TaxedPriceDraft taxedPrice) {
        this.taxedPrice = taxedPrice;
    }

    public AddressInput getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(AddressInput shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public AddressInput getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AddressInput billingAddress) {
        this.billingAddress = billingAddress;
    }

    public ReferenceInput getCustomerGroup() {
        return this.customerGroup;
    }

    public void setCustomerGroup(ReferenceInput customerGroup) {
        this.customerGroup = customerGroup;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public OrderState getOrderState() {
        return this.orderState;
    }

    public void setOrderState(OrderState orderState) {
        this.orderState = orderState;
    }

    public ShipmentState getShipmentState() {
        return this.shipmentState;
    }

    public void setShipmentState(ShipmentState shipmentState) {
        this.shipmentState = shipmentState;
    }

    public PaymentState getPaymentState() {
        return this.paymentState;
    }

    public void setPaymentState(PaymentState paymentState) {
        this.paymentState = paymentState;
    }

    public ShippingInfoImportDraft getShippingInfo() {
        return this.shippingInfo;
    }

    public void setShippingInfo(ShippingInfoImportDraft shippingInfo) {
        this.shippingInfo = shippingInfo;
    }

    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public CustomFieldsDraft getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsDraft custom) {
        this.custom = custom;
    }

    public InventoryMode getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(InventoryMode inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public ItemShippingDetailsDraft getShippingDetails() {
        return this.shippingDetails;
    }

    public void setShippingDetails(ItemShippingDetailsDraft shippingDetails) {
        this.shippingDetails = shippingDetails;
    }

    public TaxCalculationMode getTaxCalculationMode() {
        return this.taxCalculationMode;
    }

    public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
        this.taxCalculationMode = taxCalculationMode;
    }

    public CartOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(CartOrigin origin) {
        this.origin = origin;
    }

    public List<AddressInput> getItemShippingAddresses() {
        return this.itemShippingAddresses;
    }

    public void setItemShippingAddresses(List<AddressInput> itemShippingAddresses) {
        this.itemShippingAddresses = itemShippingAddresses;
    }

    public ReferenceInput getState() {
        return this.state;
    }

    public void setState(ReferenceInput state) {
        this.state = state;
    }

    public ReferenceInput getPaymentInfo() {
        return this.paymentInfo;
    }

    public void setPaymentInfo(ReferenceInput paymentInfo) {
        this.paymentInfo = paymentInfo;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public String toString() {
        return "ImportOrderDraft{orderNumber='" + this.orderNumber + "',customerId='" + this.customerId + "',customerEmail='" + this.customerEmail + "',store='" + this.store + "',lineItems='" + this.lineItems + "',customLineItems='" + this.customLineItems + "',totalPrice='" + this.totalPrice + "',taxedPrice='" + this.taxedPrice + "',shippingAddress='" + this.shippingAddress + "',billingAddress='" + this.billingAddress + "',customerGroup='" + this.customerGroup + "',country='" + this.country + "',orderState='" + (Object)((Object)this.orderState) + "',shipmentState='" + (Object)((Object)this.shipmentState) + "',paymentState='" + (Object)((Object)this.paymentState) + "',shippingInfo='" + this.shippingInfo + "',completedAt='" + this.completedAt + "',custom='" + this.custom + "',inventoryMode='" + (Object)((Object)this.inventoryMode) + "',shippingDetails='" + this.shippingDetails + "',taxCalculationMode='" + (Object)((Object)this.taxCalculationMode) + "',origin='" + (Object)((Object)this.origin) + "',itemShippingAddresses='" + this.itemShippingAddresses + "',state='" + this.state + "',paymentInfo='" + this.paymentInfo + "',purchaseOrderNumber='" + this.purchaseOrderNumber + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportOrderDraft that = (ImportOrderDraft)o;
        return Objects.equals(this.orderNumber, that.orderNumber) && Objects.equals(this.customerId, that.customerId) && Objects.equals(this.customerEmail, that.customerEmail) && Objects.equals(this.store, that.store) && Objects.equals(this.lineItems, that.lineItems) && Objects.equals(this.customLineItems, that.customLineItems) && Objects.equals(this.totalPrice, that.totalPrice) && Objects.equals(this.taxedPrice, that.taxedPrice) && Objects.equals(this.shippingAddress, that.shippingAddress) && Objects.equals(this.billingAddress, that.billingAddress) && Objects.equals(this.customerGroup, that.customerGroup) && Objects.equals(this.country, that.country) && Objects.equals((Object)this.orderState, (Object)that.orderState) && Objects.equals((Object)this.shipmentState, (Object)that.shipmentState) && Objects.equals((Object)this.paymentState, (Object)that.paymentState) && Objects.equals(this.shippingInfo, that.shippingInfo) && Objects.equals(this.completedAt, that.completedAt) && Objects.equals(this.custom, that.custom) && Objects.equals((Object)this.inventoryMode, (Object)that.inventoryMode) && Objects.equals(this.shippingDetails, that.shippingDetails) && Objects.equals((Object)this.taxCalculationMode, (Object)that.taxCalculationMode) && Objects.equals((Object)this.origin, (Object)that.origin) && Objects.equals(this.itemShippingAddresses, that.itemShippingAddresses) && Objects.equals(this.state, that.state) && Objects.equals(this.paymentInfo, that.paymentInfo) && Objects.equals(this.purchaseOrderNumber, that.purchaseOrderNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderNumber, this.customerId, this.customerEmail, this.store, this.lineItems, this.customLineItems, this.totalPrice, this.taxedPrice, this.shippingAddress, this.billingAddress, this.customerGroup, this.country, this.orderState, this.shipmentState, this.paymentState, this.shippingInfo, this.completedAt, this.custom, this.inventoryMode, this.shippingDetails, this.taxCalculationMode, this.origin, this.itemShippingAddresses, this.state, this.paymentInfo, this.purchaseOrderNumber});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String orderNumber;
        private String customerId;
        private String customerEmail;
        private ReferenceInput store;
        private List<LineItemImportDraft> lineItems = Collections.emptyList();
        private List<CustomLineItemImportDraft> customLineItems = Collections.emptyList();
        private MoneyInput totalPrice;
        private TaxedPriceDraft taxedPrice;
        private AddressInput shippingAddress;
        private AddressInput billingAddress;
        private ReferenceInput customerGroup;
        private String country;
        private OrderState orderState;
        private ShipmentState shipmentState;
        private PaymentState paymentState;
        private ShippingInfoImportDraft shippingInfo;
        private OffsetDateTime completedAt;
        private CustomFieldsDraft custom;
        private InventoryMode inventoryMode = InventoryMode.None;
        private ItemShippingDetailsDraft shippingDetails;
        private TaxCalculationMode taxCalculationMode = TaxCalculationMode.LineItemLevel;
        private CartOrigin origin = CartOrigin.Customer;
        private List<AddressInput> itemShippingAddresses = Collections.emptyList();
        private ReferenceInput state;
        private ReferenceInput paymentInfo;
        private String purchaseOrderNumber;

        public ImportOrderDraft build() {
            ImportOrderDraft result = new ImportOrderDraft();
            result.orderNumber = this.orderNumber;
            result.customerId = this.customerId;
            result.customerEmail = this.customerEmail;
            result.store = this.store;
            result.lineItems = this.lineItems;
            result.customLineItems = this.customLineItems;
            result.totalPrice = this.totalPrice;
            result.taxedPrice = this.taxedPrice;
            result.shippingAddress = this.shippingAddress;
            result.billingAddress = this.billingAddress;
            result.customerGroup = this.customerGroup;
            result.country = this.country;
            result.orderState = this.orderState;
            result.shipmentState = this.shipmentState;
            result.paymentState = this.paymentState;
            result.shippingInfo = this.shippingInfo;
            result.completedAt = this.completedAt;
            result.custom = this.custom;
            result.inventoryMode = this.inventoryMode;
            result.shippingDetails = this.shippingDetails;
            result.taxCalculationMode = this.taxCalculationMode;
            result.origin = this.origin;
            result.itemShippingAddresses = this.itemShippingAddresses;
            result.state = this.state;
            result.paymentInfo = this.paymentInfo;
            result.purchaseOrderNumber = this.purchaseOrderNumber;
            return result;
        }

        public Builder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
            return this;
        }

        public Builder store(ReferenceInput store) {
            this.store = store;
            return this;
        }

        public Builder lineItems(List<LineItemImportDraft> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Builder customLineItems(List<CustomLineItemImportDraft> customLineItems) {
            this.customLineItems = customLineItems;
            return this;
        }

        public Builder totalPrice(MoneyInput totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        public Builder taxedPrice(TaxedPriceDraft taxedPrice) {
            this.taxedPrice = taxedPrice;
            return this;
        }

        public Builder shippingAddress(AddressInput shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder billingAddress(AddressInput billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder customerGroup(ReferenceInput customerGroup) {
            this.customerGroup = customerGroup;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder orderState(OrderState orderState) {
            this.orderState = orderState;
            return this;
        }

        public Builder shipmentState(ShipmentState shipmentState) {
            this.shipmentState = shipmentState;
            return this;
        }

        public Builder paymentState(PaymentState paymentState) {
            this.paymentState = paymentState;
            return this;
        }

        public Builder shippingInfo(ShippingInfoImportDraft shippingInfo) {
            this.shippingInfo = shippingInfo;
            return this;
        }

        public Builder completedAt(OffsetDateTime completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public Builder custom(CustomFieldsDraft custom) {
            this.custom = custom;
            return this;
        }

        public Builder inventoryMode(InventoryMode inventoryMode) {
            this.inventoryMode = inventoryMode;
            return this;
        }

        public Builder shippingDetails(ItemShippingDetailsDraft shippingDetails) {
            this.shippingDetails = shippingDetails;
            return this;
        }

        public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
            this.taxCalculationMode = taxCalculationMode;
            return this;
        }

        public Builder origin(CartOrigin origin) {
            this.origin = origin;
            return this;
        }

        public Builder itemShippingAddresses(List<AddressInput> itemShippingAddresses) {
            this.itemShippingAddresses = itemShippingAddresses;
            return this;
        }

        public Builder state(ReferenceInput state) {
            this.state = state;
            return this;
        }

        public Builder paymentInfo(ReferenceInput paymentInfo) {
            this.paymentInfo = paymentInfo;
            return this;
        }

        public Builder purchaseOrderNumber(String purchaseOrderNumber) {
            this.purchaseOrderNumber = purchaseOrderNumber;
            return this;
        }
    }
}

