/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.ActiveCartInterface;
import com.commercetools.graphql.api.types.Cart;
import com.commercetools.graphql.api.types.CartQueryInterface;
import com.commercetools.graphql.api.types.CartQueryResult;
import com.commercetools.graphql.api.types.Customer;
import com.commercetools.graphql.api.types.MeQueryInterface;
import com.commercetools.graphql.api.types.Order;
import com.commercetools.graphql.api.types.OrderQueryInterface;
import com.commercetools.graphql.api.types.OrderQueryResult;
import com.commercetools.graphql.api.types.ShoppingList;
import com.commercetools.graphql.api.types.ShoppingListQueryInterface;
import com.commercetools.graphql.api.types.ShoppingListQueryResult;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class InStoreMe
implements MeQueryInterface,
CartQueryInterface,
ActiveCartInterface,
OrderQueryInterface,
ShoppingListQueryInterface {
    private Customer customer;
    private Cart cart;
    private CartQueryResult carts;
    private Cart activeCart;
    private Order order;
    private OrderQueryResult orders;
    private ShoppingList shoppingList;
    private ShoppingListQueryResult shoppingLists;

    public InStoreMe() {
    }

    public InStoreMe(Customer customer, Cart cart, CartQueryResult carts, Cart activeCart, Order order, OrderQueryResult orders, ShoppingList shoppingList, ShoppingListQueryResult shoppingLists) {
        this.customer = customer;
        this.cart = cart;
        this.carts = carts;
        this.activeCart = activeCart;
        this.order = order;
        this.orders = orders;
        this.shoppingList = shoppingList;
        this.shoppingLists = shoppingLists;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public Cart getCart() {
        return this.cart;
    }

    @Override
    public void setCart(Cart cart) {
        this.cart = cart;
    }

    @Override
    public CartQueryResult getCarts() {
        return this.carts;
    }

    @Override
    public void setCarts(CartQueryResult carts) {
        this.carts = carts;
    }

    @Override
    public Cart getActiveCart() {
        return this.activeCart;
    }

    @Override
    public void setActiveCart(Cart activeCart) {
        this.activeCart = activeCart;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public OrderQueryResult getOrders() {
        return this.orders;
    }

    @Override
    public void setOrders(OrderQueryResult orders) {
        this.orders = orders;
    }

    @Override
    public ShoppingList getShoppingList() {
        return this.shoppingList;
    }

    @Override
    public void setShoppingList(ShoppingList shoppingList) {
        this.shoppingList = shoppingList;
    }

    @Override
    public ShoppingListQueryResult getShoppingLists() {
        return this.shoppingLists;
    }

    @Override
    public void setShoppingLists(ShoppingListQueryResult shoppingLists) {
        this.shoppingLists = shoppingLists;
    }

    public String toString() {
        return "InStoreMe{customer='" + this.customer + "',cart='" + this.cart + "',carts='" + this.carts + "',activeCart='" + this.activeCart + "',order='" + this.order + "',orders='" + this.orders + "',shoppingList='" + this.shoppingList + "',shoppingLists='" + this.shoppingLists + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InStoreMe that = (InStoreMe)o;
        return Objects.equals(this.customer, that.customer) && Objects.equals(this.cart, that.cart) && Objects.equals(this.carts, that.carts) && Objects.equals(this.activeCart, that.activeCart) && Objects.equals(this.order, that.order) && Objects.equals(this.orders, that.orders) && Objects.equals(this.shoppingList, that.shoppingList) && Objects.equals(this.shoppingLists, that.shoppingLists);
    }

    public int hashCode() {
        return Objects.hash(this.customer, this.cart, this.carts, this.activeCart, this.order, this.orders, this.shoppingList, this.shoppingLists);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Customer customer;
        private Cart cart;
        private CartQueryResult carts;
        private Cart activeCart;
        private Order order;
        private OrderQueryResult orders;
        private ShoppingList shoppingList;
        private ShoppingListQueryResult shoppingLists;

        public InStoreMe build() {
            InStoreMe result = new InStoreMe();
            result.customer = this.customer;
            result.cart = this.cart;
            result.carts = this.carts;
            result.activeCart = this.activeCart;
            result.order = this.order;
            result.orders = this.orders;
            result.shoppingList = this.shoppingList;
            result.shoppingLists = this.shoppingLists;
            return result;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public Builder cart(Cart cart) {
            this.cart = cart;
            return this;
        }

        public Builder carts(CartQueryResult carts) {
            this.carts = carts;
            return this;
        }

        public Builder activeCart(Cart activeCart) {
            this.activeCart = activeCart;
            return this;
        }

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder orders(OrderQueryResult orders) {
            this.orders = orders;
            return this;
        }

        public Builder shoppingList(ShoppingList shoppingList) {
            this.shoppingList = shoppingList;
            return this;
        }

        public Builder shoppingLists(ShoppingListQueryResult shoppingLists) {
            this.shoppingLists = shoppingLists;
            return this;
        }
    }
}

