/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Channel;
import com.commercetools.graphql.api.types.CustomFieldsType;
import com.commercetools.graphql.api.types.Initiator;
import com.commercetools.graphql.api.types.Reference;
import com.commercetools.graphql.api.types.ReferenceExpandable;
import com.commercetools.graphql.api.types.Versioned;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class InventoryEntry
implements Versioned,
ReferenceExpandable {
    private String sku;
    private Long quantityOnStock;
    private Long availableQuantity;
    private String key;
    private Integer restockableInDays;
    private OffsetDateTime expectedDelivery;
    private Channel supplyChannel;
    private Reference supplyChannelRef;
    private CustomFieldsType custom;
    private String id;
    private Long version;
    private OffsetDateTime createdAt;
    private OffsetDateTime lastModifiedAt;
    private Initiator createdBy;
    private Initiator lastModifiedBy;

    public InventoryEntry() {
    }

    public InventoryEntry(String sku, Long quantityOnStock, Long availableQuantity, String key, Integer restockableInDays, OffsetDateTime expectedDelivery, Channel supplyChannel, Reference supplyChannelRef, CustomFieldsType custom, String id, Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
        this.sku = sku;
        this.quantityOnStock = quantityOnStock;
        this.availableQuantity = availableQuantity;
        this.key = key;
        this.restockableInDays = restockableInDays;
        this.expectedDelivery = expectedDelivery;
        this.supplyChannel = supplyChannel;
        this.supplyChannelRef = supplyChannelRef;
        this.custom = custom;
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.lastModifiedAt = lastModifiedAt;
        this.createdBy = createdBy;
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Long getQuantityOnStock() {
        return this.quantityOnStock;
    }

    public void setQuantityOnStock(Long quantityOnStock) {
        this.quantityOnStock = quantityOnStock;
    }

    public Long getAvailableQuantity() {
        return this.availableQuantity;
    }

    public void setAvailableQuantity(Long availableQuantity) {
        this.availableQuantity = availableQuantity;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getRestockableInDays() {
        return this.restockableInDays;
    }

    public void setRestockableInDays(Integer restockableInDays) {
        this.restockableInDays = restockableInDays;
    }

    public OffsetDateTime getExpectedDelivery() {
        return this.expectedDelivery;
    }

    public void setExpectedDelivery(OffsetDateTime expectedDelivery) {
        this.expectedDelivery = expectedDelivery;
    }

    public Channel getSupplyChannel() {
        return this.supplyChannel;
    }

    public void setSupplyChannel(Channel supplyChannel) {
        this.supplyChannel = supplyChannel;
    }

    public Reference getSupplyChannelRef() {
        return this.supplyChannelRef;
    }

    public void setSupplyChannelRef(Reference supplyChannelRef) {
        this.supplyChannelRef = supplyChannelRef;
    }

    public CustomFieldsType getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsType custom) {
        this.custom = custom;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public OffsetDateTime getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    @Override
    public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    @Override
    public Initiator getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(Initiator createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public Initiator getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public void setLastModifiedBy(Initiator lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String toString() {
        return "InventoryEntry{sku='" + this.sku + "',quantityOnStock='" + this.quantityOnStock + "',availableQuantity='" + this.availableQuantity + "',key='" + this.key + "',restockableInDays='" + this.restockableInDays + "',expectedDelivery='" + this.expectedDelivery + "',supplyChannel='" + this.supplyChannel + "',supplyChannelRef='" + this.supplyChannelRef + "',custom='" + this.custom + "',id='" + this.id + "',version='" + this.version + "',createdAt='" + this.createdAt + "',lastModifiedAt='" + this.lastModifiedAt + "',createdBy='" + this.createdBy + "',lastModifiedBy='" + this.lastModifiedBy + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryEntry that = (InventoryEntry)o;
        return Objects.equals(this.sku, that.sku) && Objects.equals(this.quantityOnStock, that.quantityOnStock) && Objects.equals(this.availableQuantity, that.availableQuantity) && Objects.equals(this.key, that.key) && Objects.equals(this.restockableInDays, that.restockableInDays) && Objects.equals(this.expectedDelivery, that.expectedDelivery) && Objects.equals(this.supplyChannel, that.supplyChannel) && Objects.equals(this.supplyChannelRef, that.supplyChannelRef) && Objects.equals(this.custom, that.custom) && Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.lastModifiedAt, that.lastModifiedAt) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.lastModifiedBy, that.lastModifiedBy);
    }

    public int hashCode() {
        return Objects.hash(this.sku, this.quantityOnStock, this.availableQuantity, this.key, this.restockableInDays, this.expectedDelivery, this.supplyChannel, this.supplyChannelRef, this.custom, this.id, this.version, this.createdAt, this.lastModifiedAt, this.createdBy, this.lastModifiedBy);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String sku;
        private Long quantityOnStock;
        private Long availableQuantity;
        private String key;
        private Integer restockableInDays;
        private OffsetDateTime expectedDelivery;
        private Channel supplyChannel;
        private Reference supplyChannelRef;
        private CustomFieldsType custom;
        private String id;
        private Long version;
        private OffsetDateTime createdAt;
        private OffsetDateTime lastModifiedAt;
        private Initiator createdBy;
        private Initiator lastModifiedBy;

        public InventoryEntry build() {
            InventoryEntry result = new InventoryEntry();
            result.sku = this.sku;
            result.quantityOnStock = this.quantityOnStock;
            result.availableQuantity = this.availableQuantity;
            result.key = this.key;
            result.restockableInDays = this.restockableInDays;
            result.expectedDelivery = this.expectedDelivery;
            result.supplyChannel = this.supplyChannel;
            result.supplyChannelRef = this.supplyChannelRef;
            result.custom = this.custom;
            result.id = this.id;
            result.version = this.version;
            result.createdAt = this.createdAt;
            result.lastModifiedAt = this.lastModifiedAt;
            result.createdBy = this.createdBy;
            result.lastModifiedBy = this.lastModifiedBy;
            return result;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder quantityOnStock(Long quantityOnStock) {
            this.quantityOnStock = quantityOnStock;
            return this;
        }

        public Builder availableQuantity(Long availableQuantity) {
            this.availableQuantity = availableQuantity;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder restockableInDays(Integer restockableInDays) {
            this.restockableInDays = restockableInDays;
            return this;
        }

        public Builder expectedDelivery(OffsetDateTime expectedDelivery) {
            this.expectedDelivery = expectedDelivery;
            return this;
        }

        public Builder supplyChannel(Channel supplyChannel) {
            this.supplyChannel = supplyChannel;
            return this;
        }

        public Builder supplyChannelRef(Reference supplyChannelRef) {
            this.supplyChannelRef = supplyChannelRef;
            return this;
        }

        public Builder custom(CustomFieldsType custom) {
            this.custom = custom;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public Builder createdBy(Initiator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder lastModifiedBy(Initiator lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }
    }
}

