/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.BaseMoney;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Currency;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class Money
implements BaseMoney {
    private String type;
    private Currency currencyCode;
    private Long centAmount;
    private Integer fractionDigits;

    public Money() {
    }

    public Money(String type, Currency currencyCode, Long centAmount, Integer fractionDigits) {
        this.type = type;
        this.currencyCode = currencyCode;
        this.centAmount = centAmount;
        this.fractionDigits = fractionDigits;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Currency getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public void setCurrencyCode(Currency currencyCode) {
        this.currencyCode = currencyCode;
    }

    @Override
    public Long getCentAmount() {
        return this.centAmount;
    }

    @Override
    public void setCentAmount(Long centAmount) {
        this.centAmount = centAmount;
    }

    @Override
    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public void setFractionDigits(Integer fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String toString() {
        return "Money{type='" + this.type + "',currencyCode='" + this.currencyCode + "',centAmount='" + this.centAmount + "',fractionDigits='" + this.fractionDigits + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money that = (Money)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.currencyCode, that.currencyCode) && Objects.equals(this.centAmount, that.centAmount) && Objects.equals(this.fractionDigits, that.fractionDigits);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.currencyCode, this.centAmount, this.fractionDigits);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private Currency currencyCode;
        private Long centAmount;
        private Integer fractionDigits;

        public Money build() {
            Money result = new Money();
            result.type = this.type;
            result.currencyCode = this.currencyCode;
            result.centAmount = this.centAmount;
            result.fractionDigits = this.fractionDigits;
            return result;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder currencyCode(Currency currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder centAmount(Long centAmount) {
            this.centAmount = centAmount;
            return this;
        }

        public Builder fractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
            return this;
        }
    }
}

