/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.AddressInput;
import com.commercetools.graphql.api.types.CustomFieldsDraft;
import com.commercetools.graphql.api.types.CustomShippingDraft;
import com.commercetools.graphql.api.types.InventoryMode;
import com.commercetools.graphql.api.types.MyLineItemDraft;
import com.commercetools.graphql.api.types.ResourceIdentifierInput;
import com.commercetools.graphql.api.types.ShippingDraft;
import com.commercetools.graphql.api.types.ShippingMode;
import com.commercetools.graphql.api.types.TaxMode;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

public class MyCartDraft {
    private Currency currency;
    private String country;
    private InventoryMode inventoryMode = InventoryMode.None;
    private CustomFieldsDraft custom;
    private String customerEmail;
    private AddressInput shippingAddress;
    private AddressInput billingAddress;
    private ResourceIdentifierInput shippingMethod;
    private TaxMode taxMode = TaxMode.Platform;
    private String locale;
    private Integer deleteDaysAfterLastModification;
    private List<AddressInput> itemShippingAddresses = Collections.emptyList();
    private List<String> discountCodes = Collections.emptyList();
    private ResourceIdentifierInput store;
    private ResourceIdentifierInput businessUnit;
    private ShippingMode shippingMode = ShippingMode.Single;
    private List<CustomShippingDraft> customShipping = Collections.emptyList();
    private List<ShippingDraft> shipping = Collections.emptyList();
    private List<MyLineItemDraft> lineItems = Collections.emptyList();

    public MyCartDraft() {
    }

    public MyCartDraft(Currency currency, String country, InventoryMode inventoryMode, CustomFieldsDraft custom, String customerEmail, AddressInput shippingAddress, AddressInput billingAddress, ResourceIdentifierInput shippingMethod, TaxMode taxMode, String locale, Integer deleteDaysAfterLastModification, List<AddressInput> itemShippingAddresses, List<String> discountCodes, ResourceIdentifierInput store, ResourceIdentifierInput businessUnit, ShippingMode shippingMode, List<CustomShippingDraft> customShipping, List<ShippingDraft> shipping, List<MyLineItemDraft> lineItems) {
        this.currency = currency;
        this.country = country;
        this.inventoryMode = inventoryMode;
        this.custom = custom;
        this.customerEmail = customerEmail;
        this.shippingAddress = shippingAddress;
        this.billingAddress = billingAddress;
        this.shippingMethod = shippingMethod;
        this.taxMode = taxMode;
        this.locale = locale;
        this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
        this.itemShippingAddresses = itemShippingAddresses;
        this.discountCodes = discountCodes;
        this.store = store;
        this.businessUnit = businessUnit;
        this.shippingMode = shippingMode;
        this.customShipping = customShipping;
        this.shipping = shipping;
        this.lineItems = lineItems;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public InventoryMode getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(InventoryMode inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public CustomFieldsDraft getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsDraft custom) {
        this.custom = custom;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public AddressInput getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(AddressInput shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public AddressInput getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AddressInput billingAddress) {
        this.billingAddress = billingAddress;
    }

    public ResourceIdentifierInput getShippingMethod() {
        return this.shippingMethod;
    }

    public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public TaxMode getTaxMode() {
        return this.taxMode;
    }

    public void setTaxMode(TaxMode taxMode) {
        this.taxMode = taxMode;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Integer getDeleteDaysAfterLastModification() {
        return this.deleteDaysAfterLastModification;
    }

    public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
        this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
    }

    public List<AddressInput> getItemShippingAddresses() {
        return this.itemShippingAddresses;
    }

    public void setItemShippingAddresses(List<AddressInput> itemShippingAddresses) {
        this.itemShippingAddresses = itemShippingAddresses;
    }

    public List<String> getDiscountCodes() {
        return this.discountCodes;
    }

    public void setDiscountCodes(List<String> discountCodes) {
        this.discountCodes = discountCodes;
    }

    public ResourceIdentifierInput getStore() {
        return this.store;
    }

    public void setStore(ResourceIdentifierInput store) {
        this.store = store;
    }

    public ResourceIdentifierInput getBusinessUnit() {
        return this.businessUnit;
    }

    public void setBusinessUnit(ResourceIdentifierInput businessUnit) {
        this.businessUnit = businessUnit;
    }

    public ShippingMode getShippingMode() {
        return this.shippingMode;
    }

    public void setShippingMode(ShippingMode shippingMode) {
        this.shippingMode = shippingMode;
    }

    public List<CustomShippingDraft> getCustomShipping() {
        return this.customShipping;
    }

    public void setCustomShipping(List<CustomShippingDraft> customShipping) {
        this.customShipping = customShipping;
    }

    public List<ShippingDraft> getShipping() {
        return this.shipping;
    }

    public void setShipping(List<ShippingDraft> shipping) {
        this.shipping = shipping;
    }

    public List<MyLineItemDraft> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<MyLineItemDraft> lineItems) {
        this.lineItems = lineItems;
    }

    public String toString() {
        return "MyCartDraft{currency='" + this.currency + "',country='" + this.country + "',inventoryMode='" + (Object)((Object)this.inventoryMode) + "',custom='" + this.custom + "',customerEmail='" + this.customerEmail + "',shippingAddress='" + this.shippingAddress + "',billingAddress='" + this.billingAddress + "',shippingMethod='" + this.shippingMethod + "',taxMode='" + (Object)((Object)this.taxMode) + "',locale='" + this.locale + "',deleteDaysAfterLastModification='" + this.deleteDaysAfterLastModification + "',itemShippingAddresses='" + this.itemShippingAddresses + "',discountCodes='" + this.discountCodes + "',store='" + this.store + "',businessUnit='" + this.businessUnit + "',shippingMode='" + (Object)((Object)this.shippingMode) + "',customShipping='" + this.customShipping + "',shipping='" + this.shipping + "',lineItems='" + this.lineItems + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MyCartDraft that = (MyCartDraft)o;
        return Objects.equals(this.currency, that.currency) && Objects.equals(this.country, that.country) && Objects.equals((Object)this.inventoryMode, (Object)that.inventoryMode) && Objects.equals(this.custom, that.custom) && Objects.equals(this.customerEmail, that.customerEmail) && Objects.equals(this.shippingAddress, that.shippingAddress) && Objects.equals(this.billingAddress, that.billingAddress) && Objects.equals(this.shippingMethod, that.shippingMethod) && Objects.equals((Object)this.taxMode, (Object)that.taxMode) && Objects.equals(this.locale, that.locale) && Objects.equals(this.deleteDaysAfterLastModification, that.deleteDaysAfterLastModification) && Objects.equals(this.itemShippingAddresses, that.itemShippingAddresses) && Objects.equals(this.discountCodes, that.discountCodes) && Objects.equals(this.store, that.store) && Objects.equals(this.businessUnit, that.businessUnit) && Objects.equals((Object)this.shippingMode, (Object)that.shippingMode) && Objects.equals(this.customShipping, that.customShipping) && Objects.equals(this.shipping, that.shipping) && Objects.equals(this.lineItems, that.lineItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currency, this.country, this.inventoryMode, this.custom, this.customerEmail, this.shippingAddress, this.billingAddress, this.shippingMethod, this.taxMode, this.locale, this.deleteDaysAfterLastModification, this.itemShippingAddresses, this.discountCodes, this.store, this.businessUnit, this.shippingMode, this.customShipping, this.shipping, this.lineItems});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Currency currency;
        private String country;
        private InventoryMode inventoryMode = InventoryMode.None;
        private CustomFieldsDraft custom;
        private String customerEmail;
        private AddressInput shippingAddress;
        private AddressInput billingAddress;
        private ResourceIdentifierInput shippingMethod;
        private TaxMode taxMode = TaxMode.Platform;
        private String locale;
        private Integer deleteDaysAfterLastModification;
        private List<AddressInput> itemShippingAddresses = Collections.emptyList();
        private List<String> discountCodes = Collections.emptyList();
        private ResourceIdentifierInput store;
        private ResourceIdentifierInput businessUnit;
        private ShippingMode shippingMode = ShippingMode.Single;
        private List<CustomShippingDraft> customShipping = Collections.emptyList();
        private List<ShippingDraft> shipping = Collections.emptyList();
        private List<MyLineItemDraft> lineItems = Collections.emptyList();

        public MyCartDraft build() {
            MyCartDraft result = new MyCartDraft();
            result.currency = this.currency;
            result.country = this.country;
            result.inventoryMode = this.inventoryMode;
            result.custom = this.custom;
            result.customerEmail = this.customerEmail;
            result.shippingAddress = this.shippingAddress;
            result.billingAddress = this.billingAddress;
            result.shippingMethod = this.shippingMethod;
            result.taxMode = this.taxMode;
            result.locale = this.locale;
            result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
            result.itemShippingAddresses = this.itemShippingAddresses;
            result.discountCodes = this.discountCodes;
            result.store = this.store;
            result.businessUnit = this.businessUnit;
            result.shippingMode = this.shippingMode;
            result.customShipping = this.customShipping;
            result.shipping = this.shipping;
            result.lineItems = this.lineItems;
            return result;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder inventoryMode(InventoryMode inventoryMode) {
            this.inventoryMode = inventoryMode;
            return this;
        }

        public Builder custom(CustomFieldsDraft custom) {
            this.custom = custom;
            return this;
        }

        public Builder customerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
            return this;
        }

        public Builder shippingAddress(AddressInput shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder billingAddress(AddressInput billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
            this.shippingMethod = shippingMethod;
            return this;
        }

        public Builder taxMode(TaxMode taxMode) {
            this.taxMode = taxMode;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
            this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
            return this;
        }

        public Builder itemShippingAddresses(List<AddressInput> itemShippingAddresses) {
            this.itemShippingAddresses = itemShippingAddresses;
            return this;
        }

        public Builder discountCodes(List<String> discountCodes) {
            this.discountCodes = discountCodes;
            return this;
        }

        public Builder store(ResourceIdentifierInput store) {
            this.store = store;
            return this;
        }

        public Builder businessUnit(ResourceIdentifierInput businessUnit) {
            this.businessUnit = businessUnit;
            return this;
        }

        public Builder shippingMode(ShippingMode shippingMode) {
            this.shippingMode = shippingMode;
            return this;
        }

        public Builder customShipping(List<CustomShippingDraft> customShipping) {
            this.customShipping = customShipping;
            return this;
        }

        public Builder shipping(List<ShippingDraft> shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder lineItems(List<MyLineItemDraft> lineItems) {
            this.lineItems = lineItems;
            return this;
        }
    }
}

