/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Product;
import com.commercetools.graphql.api.types.ProductVariantExclusion;
import com.commercetools.graphql.api.types.ProductVariantSelection;
import com.commercetools.graphql.api.types.Reference;
import java.util.Objects;

public class ProductOfSelection {
    private Reference productRef;
    private Product product;
    private ProductVariantSelection variantSelection;
    private ProductVariantExclusion variantExclusion;

    public ProductOfSelection() {
    }

    public ProductOfSelection(Reference productRef, Product product, ProductVariantSelection variantSelection, ProductVariantExclusion variantExclusion) {
        this.productRef = productRef;
        this.product = product;
        this.variantSelection = variantSelection;
        this.variantExclusion = variantExclusion;
    }

    public Reference getProductRef() {
        return this.productRef;
    }

    public void setProductRef(Reference productRef) {
        this.productRef = productRef;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public ProductVariantSelection getVariantSelection() {
        return this.variantSelection;
    }

    public void setVariantSelection(ProductVariantSelection variantSelection) {
        this.variantSelection = variantSelection;
    }

    public ProductVariantExclusion getVariantExclusion() {
        return this.variantExclusion;
    }

    public void setVariantExclusion(ProductVariantExclusion variantExclusion) {
        this.variantExclusion = variantExclusion;
    }

    public String toString() {
        return "ProductOfSelection{productRef='" + this.productRef + "',product='" + this.product + "',variantSelection='" + this.variantSelection + "',variantExclusion='" + this.variantExclusion + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOfSelection that = (ProductOfSelection)o;
        return Objects.equals(this.productRef, that.productRef) && Objects.equals(this.product, that.product) && Objects.equals(this.variantSelection, that.variantSelection) && Objects.equals(this.variantExclusion, that.variantExclusion);
    }

    public int hashCode() {
        return Objects.hash(this.productRef, this.product, this.variantSelection, this.variantExclusion);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Reference productRef;
        private Product product;
        private ProductVariantSelection variantSelection;
        private ProductVariantExclusion variantExclusion;

        public ProductOfSelection build() {
            ProductOfSelection result = new ProductOfSelection();
            result.productRef = this.productRef;
            result.product = this.product;
            result.variantSelection = this.variantSelection;
            result.variantExclusion = this.variantExclusion;
            return result;
        }

        public Builder productRef(Reference productRef) {
            this.productRef = productRef;
            return this;
        }

        public Builder product(Product product) {
            this.product = product;
            return this;
        }

        public Builder variantSelection(ProductVariantSelection variantSelection) {
            this.variantSelection = variantSelection;
            return this;
        }

        public Builder variantExclusion(ProductVariantExclusion variantExclusion) {
            this.variantExclusion = variantExclusion;
            return this;
        }
    }
}

