/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Asset;
import com.commercetools.graphql.api.types.Image;
import com.commercetools.graphql.api.types.ProductPrice;
import com.commercetools.graphql.api.types.ProductVariantAvailabilityWithChannels;
import com.commercetools.graphql.api.types.RawProductAttribute;
import java.util.List;
import java.util.Objects;

public class ProductVariant {
    private Integer id;
    private String key;
    private String sku;
    private List<ProductPrice> prices;
    private ProductPrice price;
    private List<Image> images;
    private List<Asset> assets;
    private ProductVariantAvailabilityWithChannels availability;
    private List<RawProductAttribute> attributesRaw;

    public ProductVariant() {
    }

    public ProductVariant(Integer id, String key, String sku, List<ProductPrice> prices, ProductPrice price, List<Image> images, List<Asset> assets, ProductVariantAvailabilityWithChannels availability, List<RawProductAttribute> attributesRaw) {
        this.id = id;
        this.key = key;
        this.sku = sku;
        this.prices = prices;
        this.price = price;
        this.images = images;
        this.assets = assets;
        this.availability = availability;
        this.attributesRaw = attributesRaw;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public List<ProductPrice> getPrices() {
        return this.prices;
    }

    public void setPrices(List<ProductPrice> prices) {
        this.prices = prices;
    }

    public ProductPrice getPrice() {
        return this.price;
    }

    public void setPrice(ProductPrice price) {
        this.price = price;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    public ProductVariantAvailabilityWithChannels getAvailability() {
        return this.availability;
    }

    public void setAvailability(ProductVariantAvailabilityWithChannels availability) {
        this.availability = availability;
    }

    public List<RawProductAttribute> getAttributesRaw() {
        return this.attributesRaw;
    }

    public void setAttributesRaw(List<RawProductAttribute> attributesRaw) {
        this.attributesRaw = attributesRaw;
    }

    public String toString() {
        return "ProductVariant{id='" + this.id + "',key='" + this.key + "',sku='" + this.sku + "',prices='" + this.prices + "',price='" + this.price + "',images='" + this.images + "',assets='" + this.assets + "',availability='" + this.availability + "',attributesRaw='" + this.attributesRaw + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductVariant that = (ProductVariant)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key) && Objects.equals(this.sku, that.sku) && Objects.equals(this.prices, that.prices) && Objects.equals(this.price, that.price) && Objects.equals(this.images, that.images) && Objects.equals(this.assets, that.assets) && Objects.equals(this.availability, that.availability) && Objects.equals(this.attributesRaw, that.attributesRaw);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.sku, this.prices, this.price, this.images, this.assets, this.availability, this.attributesRaw);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer id;
        private String key;
        private String sku;
        private List<ProductPrice> prices;
        private ProductPrice price;
        private List<Image> images;
        private List<Asset> assets;
        private ProductVariantAvailabilityWithChannels availability;
        private List<RawProductAttribute> attributesRaw;

        public ProductVariant build() {
            ProductVariant result = new ProductVariant();
            result.id = this.id;
            result.key = this.key;
            result.sku = this.sku;
            result.prices = this.prices;
            result.price = this.price;
            result.images = this.images;
            result.assets = this.assets;
            result.availability = this.availability;
            result.attributesRaw = this.attributesRaw;
            return result;
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder prices(List<ProductPrice> prices) {
            this.prices = prices;
            return this;
        }

        public Builder price(ProductPrice price) {
            this.price = price;
            return this;
        }

        public Builder images(List<Image> images) {
            this.images = images;
            return this;
        }

        public Builder assets(List<Asset> assets) {
            this.assets = assets;
            return this;
        }

        public Builder availability(ProductVariantAvailabilityWithChannels availability) {
            this.availability = availability;
            return this;
        }

        public Builder attributesRaw(List<RawProductAttribute> attributesRaw) {
            this.attributesRaw = attributesRaw;
            return this;
        }
    }
}

