/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.ProductVariant;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ProductVariantAdded
implements MessagePayload {
    private ProductVariant variant;
    private Boolean staged;
    private String type;

    public ProductVariantAdded() {
    }

    public ProductVariantAdded(ProductVariant variant, Boolean staged, String type) {
        this.variant = variant;
        this.staged = staged;
        this.type = type;
    }

    public ProductVariant getVariant() {
        return this.variant;
    }

    public void setVariant(ProductVariant variant) {
        this.variant = variant;
    }

    public Boolean getStaged() {
        return this.staged;
    }

    public void setStaged(Boolean staged) {
        this.staged = staged;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ProductVariantAdded{variant='" + this.variant + "',staged='" + this.staged + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductVariantAdded that = (ProductVariantAdded)o;
        return Objects.equals(this.variant, that.variant) && Objects.equals(this.staged, that.staged) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.variant, this.staged, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ProductVariant variant;
        private Boolean staged;
        private String type;

        public ProductVariantAdded build() {
            ProductVariantAdded result = new ProductVariantAdded();
            result.variant = this.variant;
            result.staged = this.staged;
            result.type = this.type;
            return result;
        }

        public Builder variant(ProductVariant variant) {
            this.variant = variant;
            return this;
        }

        public Builder staged(Boolean staged) {
            this.staged = staged;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

