/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.AssetDraftInput;
import com.commercetools.graphql.api.types.ImageInput;
import com.commercetools.graphql.api.types.ProductAttributeInput;
import com.commercetools.graphql.api.types.ProductPriceDataInput;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductVariantInput {
    private String sku;
    private String key;
    private List<ProductPriceDataInput> prices = Collections.emptyList();
    private List<ImageInput> images = Collections.emptyList();
    private List<ProductAttributeInput> attributes = Collections.emptyList();
    private List<AssetDraftInput> assets = Collections.emptyList();

    public ProductVariantInput() {
    }

    public ProductVariantInput(String sku, String key, List<ProductPriceDataInput> prices, List<ImageInput> images, List<ProductAttributeInput> attributes, List<AssetDraftInput> assets) {
        this.sku = sku;
        this.key = key;
        this.prices = prices;
        this.images = images;
        this.attributes = attributes;
        this.assets = assets;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<ProductPriceDataInput> getPrices() {
        return this.prices;
    }

    public void setPrices(List<ProductPriceDataInput> prices) {
        this.prices = prices;
    }

    public List<ImageInput> getImages() {
        return this.images;
    }

    public void setImages(List<ImageInput> images) {
        this.images = images;
    }

    public List<ProductAttributeInput> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ProductAttributeInput> attributes) {
        this.attributes = attributes;
    }

    public List<AssetDraftInput> getAssets() {
        return this.assets;
    }

    public void setAssets(List<AssetDraftInput> assets) {
        this.assets = assets;
    }

    public String toString() {
        return "ProductVariantInput{sku='" + this.sku + "',key='" + this.key + "',prices='" + this.prices + "',images='" + this.images + "',attributes='" + this.attributes + "',assets='" + this.assets + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductVariantInput that = (ProductVariantInput)o;
        return Objects.equals(this.sku, that.sku) && Objects.equals(this.key, that.key) && Objects.equals(this.prices, that.prices) && Objects.equals(this.images, that.images) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.assets, that.assets);
    }

    public int hashCode() {
        return Objects.hash(this.sku, this.key, this.prices, this.images, this.attributes, this.assets);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String sku;
        private String key;
        private List<ProductPriceDataInput> prices = Collections.emptyList();
        private List<ImageInput> images = Collections.emptyList();
        private List<ProductAttributeInput> attributes = Collections.emptyList();
        private List<AssetDraftInput> assets = Collections.emptyList();

        public ProductVariantInput build() {
            ProductVariantInput result = new ProductVariantInput();
            result.sku = this.sku;
            result.key = this.key;
            result.prices = this.prices;
            result.images = this.images;
            result.attributes = this.attributes;
            result.assets = this.assets;
            return result;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder prices(List<ProductPriceDataInput> prices) {
            this.prices = prices;
            return this;
        }

        public Builder images(List<ImageInput> images) {
            this.images = images;
            return this;
        }

        public Builder attributes(List<ProductAttributeInput> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder assets(List<AssetDraftInput> assets) {
            this.assets = assets;
            return this;
        }
    }
}

